#include "mbed.h"
#include "GPS.h"
#include "SCP1000.h"

/*
$PMTK251,115200*1F
$PMTK220,100*2F
RMC,VTG,GGA
$PMTK314,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*2A
*/
#define GPSTX p9
#define GPSRX p10
#define PCBAUD 115200
#define GPSBAUD 115200

#define DEGREES 176
// 176 is degree untranslated
// 248 is degree translated

Serial pc(USBTX, USBRX);
GPS gps(GPSTX, GPSRX);
SCP1000 scp1000(p11,p12,p13,p14);
//SDFileSystem sd(p5,p6,p7,p8,"sd");

char rmc[GPS_BUFFER_LEN];
char gga[GPS_BUFFER_LEN];
char vtg[GPS_BUFFER_LEN];

bool validgps;
bool validtime;
short int sats;
double latitude;
double longitude;
float altitude;
float pressure;
float velocity;
float track;

DigitalOut led1(LED1);
Timeout t1;
void t1out(void) { led1 = 0; }
void blip1(void) { led1 = 1; t1.attach(&t1out, 0.01); }

DigitalOut led2(LED2);
Timeout t2;
void t2out(void) { led2 = 0; }
void blip2(void) { led2 = 1; t2.attach(&t2out, 0.01); }

DigitalOut led3(LED3);
Timeout t3;
void t3out(void) { led3 = 0; }
void blip3(void) { led3 = 1; t3.attach(&t3out, 0.01); }

DigitalOut led4(LED4);
Timeout t4;
void t4out(void) { led4 = 0; }
void blip4(void) { led4 = 1; t4.attach(&t4out, 0.01); }

GPS_Geodetic g;
GPS_VTG v;

void pos(void) {
    blip4();
    gps.geodetic(&g);
    gps.vtg(&v);
    latitude  = g.lat;
    longitude = g.lon;
    altitude  = g.alt;
    velocity = v._velocity_knots;
    track = v._track_true;
    sats = gps.numOfSats();
    validgps = false;
    validtime = false;
    validgps = gps.getGPSquality();
    validtime = gps.isTimeValid();
    if (!validgps) { latitude = 0.000000; longitude = 0.000000; velocity = 0.000000; track = 0.000000; }
    pc.printf("GPS: %i(%i), TIME: %i\r\nLAT: %f\r\nLON: %f\r\nALT: %5.1lf ft\r\nPRES: %d Pa\r\nTEMP: %3.1lf %cC\r\nSPD: %3.1lf kts\r\nTRK: %3.1lf %cT\r\n", validgps, sats, validtime, latitude, longitude, altitude, scp1000.readPressure(), scp1000.readTemperature(), DEGREES, velocity, track, DEGREES); // 1.0m = 3.2808399 ft - 1.0km = 3280.8399 ft
    time_t seconds = time(NULL);
    pc.printf("%s\r\n", ctime(&seconds));
    }

int main() {

    pc.baud(PCBAUD);
    gps.baud(GPSBAUD);
    gps.format(8, GPS::None, 1);
  
    //gps.setRmc(rmc);
    //gps.setGga(gga);
    //gps.setVtg(vtg);
    
    //gps.attach_rmc(&rmc);
    //gps.attach_vtg(&vtg);
    //gps.attach_gga(&gga);

    struct tm t;
    GPS_Time *q2 = gps.timeNow();

    while (q2->year == 2000) {
        wait(0.1);
        GPS_Time *q2 = gps.timeNow();
        t.tm_sec = q2->second;    // 0-59
        t.tm_min = q2->minute;    // 0-59
        t.tm_hour = q2->hour;   // 0-23
        t.tm_mday = q2->day;   // 1-31
        t.tm_mon = (q2->month - 1);     // 0-11
        t.tm_year = (q2->year - 1900);  // year since 1900
        time_t timestamp = mktime(&t);
        set_time(timestamp);
        if (q2->year != 2000) break;
        pc.printf(".");
    }
    delete(q2);
    pc.printf("\r\n");

    gps.attach_gga(&pos);
    gps.attach_rmc(&pos);
}
