#include <string.h>
#include "HTTPServer.h"
#include "MbedJSONValue.h"

extern MbedJSONValue WIZwikiREST;

bool cmp(char* a, char* b)
{
    return strcmp(a,b) < 0;
}

HTTPServer::HTTPServer():
socket(),
handlers(&cmp)
{
}

HTTPServer::~HTTPServer()
{
    for(std::map<char*, RequestHandler*>::iterator itor = handlers.begin();
        itor != handlers.end();
        ++itor)
        delete itor->second;
}

bool HTTPServer::init(int port)
{
    socket.set_blocking(true);
    if(socket.bind(port))
    {
        printf("Could not bind on port %d.\n", port);
        return false; 
    }
    
    if(socket.listen())
    {
        printf("Could not listen %d\n", port);
        return false;
    }
    
    return true;
}

void HTTPServer::run()
{
    TCPSocketConnection c;
    while(true)
    {
        while(socket.accept(c));
        c.set_blocking(false, 1000);
        while(c.is_connected())
        {

            int n = c.receive_all(HTTPBUF, sizeof(HTTPBUF)-1);
                                
                        if(n == 0)
            {
                c.close();
                break;
            }
            else if(n != -1)
            {
#ifdef DEBUG_HTTP                                                
                                printf("Received data : %d\r\n",n);
#endif                                
                            
                                    HTTPBUF[n] = '\0';
                                    if(handle_request(HTTPBUF) == HTTP_SUCCESS)
                               {
                                       c.send(rest_result, strlen(rest_result));
                                       //c.send((char*)rest_result.c_str(), 159);
                                 }
                                 else
                                 {
                                       //printf("send fail : %s\r\n",(char*)rest_result.c_str());
                                       c.send(rest_result, strlen(rest_result));
                                 }
            }
            else
                printf("Error while receiving data\n");
                
        }
    }
}
 

HTTP_RESULT HTTPServer::handle_request(char *buffer)
{
    char *request_type;
    char *request;
    
//{"Name":"WIZwiki-REST-01","Network":{"IP":"192.168.100.100","SN":"255.255.255.0","GW":"192.168.100.1"},"User":{"Name":"Lawrence","ID":"law","PSWD":"law1234"}}   159
    if(buffer)
    {
#ifdef DEBUG_HTTP                
                // buffer check
                printf("*******************************************************\r\n");
        printf("buffer=%s\r\n",buffer);
                printf("*******************************************************\r\n");
#endif                                
              // type parsing
              request_type = strtok(buffer," \r\n");
#ifdef DEBUG_HTTP                              
        printf("Type = %s\r\n", request_type);
#endif        
            
                if(request_type)
        {
                      request = strtok(NULL, "  \r\n");                                                 // corrested  " " -> " /"     : /Name -> Name
            if(request)
            {
#ifdef DEBUG_HTTP                                    
                    printf("URI = %s\r\n", request);
#endif                    
                        }
                        else
                        {
              strcpy(rest_result, "Invaild URI");
#ifdef DEBUG_HTTP                              
                            printf("%s\r\n",rest_result);
#endif                            
              return HTTP_INVALID_URI;
            }
        }
    }
    
    std::map<char*, RequestHandler*>::iterator itor = handlers.find(request_type);
    if(itor == handlers.end())
    {
        strcpy(rest_result, "No request handler found for this type of request.");
        return HTTP_INVALID_HANDLE;
    }
    //if(itor != NULL)
        //itor->handle(request, rest_result.c_str());
    if(itor->second != NULL)
        itor->second->handle(request, rest_result);
    else
    {
        strcpy(rest_result, "Invalid request handler");
        return HTTP_INVALID_HANDLE;
    }
    return HTTP_SUCCESS;
}

void HTTPServer::add_request_handler(char *name, RequestHandler* handler)
{
    handlers[name] = handler;
}

