#include "mbed.h"
#include "HTTPServer.h"
#include "RequestHandler.h"
#include "EthernetInterface.h"
#include "MbedJSONValue.h"

#define SERVER_PORT 80

#define DHCP

EthernetInterface eth;
HTTPServer WIZwikiWebSvr;
MbedJSONValue WIZwikiREST;

// Enter a MAC address for your controller below.
uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0xFE};
char mac_str[20];
char ip_addr[] = "192.168.100.100";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "192.168.100.1";

DigitalOut LED_1(PA_1);
DigitalOut LED_2(PA_2);

DigitalInOut GP05(P5);
DigitalInOut GP06(P6);
DigitalInOut GP07(P7);
DigitalInOut GP08(P8);
DigitalInOut GP09(P9);
DigitalInOut GP10(P10);
DigitalInOut GP11(P11);
DigitalInOut GP12(P12);
DigitalInOut GP13(P13);
DigitalInOut GP14(P14);
DigitalInOut GP15(P15);
DigitalInOut GP16(P16);
DigitalInOut GP17(P17);
DigitalInOut GP18(P18);
DigitalInOut GP19(P19);
DigitalInOut GP20(P20);
DigitalInOut GP21(P21);
DigitalInOut GP22(P22);
DigitalInOut GP23(P23);
DigitalInOut GP24(P24);
DigitalInOut GP25(P25);
DigitalInOut GP26(P26);
DigitalInOut GP27(P27);
DigitalInOut GP28(P28);
DigitalInOut GP29(P29);
DigitalInOut GP30(P30);
DigitalInOut GP31(P31);
DigitalInOut GP32(P32);

bool p5_set(void* param)
{
    if(!param) return false;
    GP05.write(*(int*)param);
    return true;
}
bool p6_set(void* param)
{
    if(!param) return false;
    GP06.write(*(int*)param);
    return true;
}
bool p7_set(void* param)
{
    if(!param) return false;
    GP07.write(*(int*)param);
    return true;
}
bool p8_set(void* param)
{
    if(!param) return false;
    GP08.write(*(int*)param);
    return true;
}
bool p9_set(void* param)
{
    if(!param) return false;
    GP09.write(*(int*)param);
    return true;
}
bool p10_set(void* param)
{
    if(!param) return false;
    GP10.write(*(int*)param);
    return true;
}
bool p11_set(void* param)
{
    if(!param) return false;
    GP11.write(*(int*)param);
    return true;
}
bool p12_set(void* param)
{
    if(!param) return false;
    GP12.write(*(int*)param);
    return true;
}
bool p13_set(void* param)
{
    if(!param) return false;
    GP13.write(*(int*)param);
    return true;
}
bool p14_set(void* param)
{
    if(!param) return false;
    GP14.write(*(int*)param);
    return true;
}
bool p15_set(void* param)
{
    if(!param) return false;
    GP15.write(*(int*)param);
    return true;
}
bool p16_set(void* param)
{
    if(!param) return false;
    GP16.write(*(int*)param);
    return true;
}
bool p17_set(void* param)
{
    if(!param) return false;
    GP17.write(*(int*)param);
    return true;
}
bool p18_set(void* param)
{
    if(!param) return false;
    GP18.write(*(int*)param);
    return true;
}
bool p19_set(void* param)
{
    if(!param) return false;
    GP19.write(*(int*)param);
    return true;
}
bool p20_set(void* param)
{
    if(!param) return false;
    GP20.write(*(int*)param);
    return true;
}
bool p21_set(void* param)
{
    if(!param) return false;
    GP21.write(*(int*)param);
    return true;
}
bool p22_set(void* param)
{
    if(!param) return false;
    GP22.write(*(int*)param);
    return true;
}
bool p23_set(void* param)
{
    if(!param) return false;
    GP23.write(*(int*)param);
    return true;
}
bool p24_set(void* param)
{
    if(!param) return false;
    GP24.write(*(int*)param);
    return true;
}
bool p25_set(void* param)
{
    if(!param) return false;
    GP25.write(*(int*)param);
    return true;
}
bool p26_set(void* param)
{
    if(!param) return false;
    GP26.write(*(int*)param);
    return true;
}
bool p27_set(void* param)
{
    if(!param) return false;
    GP27.write(*(int*)param);
    return true;
}
bool p28_set(void* param)
{
    if(!param) return false;
    GP28.write(*(int*)param);
    return true;
}
bool p29_set(void* param)
{
    if(!param) return false;
    GP29.write(*(int*)param);
    return true;
}
bool p30_set(void* param)
{
    if(!param) return false;
    GP30.write(*(int*)param);
    return true;
}
bool p31_set(void* param)
{
    if(!param) return false;
    GP31.write(*(int*)param);
    return true;
}
bool p32_set(void* param)
{
    if(!param) return false;
    GP32.write(*(int*)param);
    return true;
}

void debug_info()
{
    printf("SP:0x%X\r\n",__current_sp());
    __heapstats((__heapprt)fprintf,stderr);
    printf("\r\n");
}    
void WIZwiki_REST_init();

int main(void)
{

    sprintf(mac_str, "%02X:%02X:%02X:%02X:%02X:%02X",mac_addr[0],mac_addr[1],
                                                     mac_addr[2],mac_addr[3], 
                                                     mac_addr[4],mac_addr[5]);
    //GPIO Set
    GP05.output();
    GP05.write(1);
    GP06.output();
    GP06.write(1);
    GP07.output();
    GP07.write(1);
    GP08.output();
    GP08.write(1);
    GP09.output();
    GP09.write(1);
    GP10.output();
    GP10.write(1);
    GP11.output();
    GP11.write(1);
    GP12.output();
    GP12.write(1);
    GP13.output();
    GP13.write(1);
    GP14.output();
    GP14.write(1);
    GP15.output();
    GP15.write(1);
    GP16.output();
    GP16.write(1);
    GP17.output();
    GP17.write(1);
    GP18.output();
    GP18.write(1);
    GP19.output();
    GP19.write(1);
    GP20.output();
    GP20.write(1);
    GP21.output();
    GP21.write(1);
    GP22.output();
    GP22.write(1);
    GP23.output();
    GP23.write(1);
    GP24.output();
    GP24.write(1);
    GP25.output();
    GP25.write(1);
    GP26.output();
    GP26.write(1);
    GP27.output();
    GP27.write(1);
    GP28.output();
    GP28.write(1);
    GP29.output();
    GP29.write(1);


    //LED Setbit
    LED_1.write(0); // LED On
    LED_2.write(1); // LED Off
    printf("START \r\n");    
    printf("sizeof(MbedJSONValue)=%d\r\n",sizeof(MbedJSONValue));
    printf("sizeof(vector)=%d\r\n",sizeof(std::vector<string*>));
    printf("sizeof(string)=%d\r\n",sizeof(std::string));
    debug_info();

    WIZwiki_REST_init();

    debug_info();
                    
    // Serialize it into a JSON string
    printf("\r\n");
    printf("-------------------------WIZwikiREST--------------------------- \r\n");
    printf("%s\r\n", WIZwikiREST.serialize().c_str());
    printf("--------------------------------------------------------------- \r\n");

    WIZwikiWebSvr.add_request_handler("GET", new GetRequestHandler());
    //WIZwikiWebSvr.add_request_handler("DELETE", new DeleteRequestHandler());
    //WIZwikiWebSvr.add_request_handler("PUT", new PutRequestHandler());
    
    #ifdef DHCP
        eth.init(mac_addr); //Use DHCP
    #else
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif
    
    
    printf("Check Ethernet Link\r\n");
    //Add
    do{
        printf("   Link - Wait... \r\n");
        wait(1);
    }while(!eth.ethernet_link());
    printf("-- Ethetnet PHY Link - Done -- \r\n");
        
    if (eth.connect() < 0 )
        printf("-- EThernet Connect - Fail -- \r\n");
    else
    {
        printf("-- Assigned Network Information -- \r\n");
        printf("   IP   : %s\r\n\r\n", eth.getIPAddress()); 
        printf("   MASK : %s\r\n\r\n", eth.getNetworkMask());
        printf("   GW   : %s\r\n\r\n", eth.getGateway());
    }
        
    //while(1) //Wait link up
    //{
    //    if(eth.link() == true) 
    //    break;
    //}
    
    printf("Link up\r\n");
    printf("IP Address is %s\r\n", eth.getIPAddress());

    if(!WIZwikiWebSvr.init(SERVER_PORT))
    {
        eth.disconnect();
        return -1;
    }

    while(1)
    {
        WIZwikiWebSvr.run();
    }
}

void WIZwiki_REST_init(void)
{
    //Fill the object
    WIZwikiREST["Name"] = "WIZwiki-RESTful-01";
    WIZwikiREST["Name"].accessible = false;
    debug_info();
    
    //Network

    WIZwikiREST["Network"]["MAC"] = mac_str;
    debug_info();
    WIZwikiREST["Network"]["IP"] = ip_addr; 
    WIZwikiREST["Network"]["IP"].accessible = true; 
    debug_info();
    WIZwikiREST["Network"]["SN"] = subnet_mask;  
    WIZwikiREST["Network"]["SN"].accessible = true;  
    debug_info();
    WIZwikiREST["Network"]["GW"] = gateway_addr;
    WIZwikiREST["Network"]["GW"].accessible = true;
    debug_info();

    //LEDs
    WIZwikiREST["LED1"] = (LED_1.read() ? "Off" : "On");
    WIZwikiREST["LED1"].accessible = true;
    debug_info();    
    WIZwikiREST["LED2"] = (LED_2.read() ? "Off" : "On");
    WIZwikiREST["LED2"].accessible = true;
    debug_info();
    // GPIOs
    WIZwikiREST["GPIOs"]["P05"] = GP05.read();
    WIZwikiREST["GPIOs"]["P05"].accessible = true;
    WIZwikiREST["GPIOs"]["P05"].cb_action = p5_set;
    WIZwikiREST["GPIOs"]["P06"] = GP06.read();
    WIZwikiREST["GPIOs"]["P06"].accessible = true;
    WIZwikiREST["GPIOs"]["P06"].cb_action = p6_set;
    WIZwikiREST["GPIOs"]["P07"] = GP07.read();
    WIZwikiREST["GPIOs"]["P07"].accessible = true;
    WIZwikiREST["GPIOs"]["P07"].cb_action = p7_set;
    WIZwikiREST["GPIOs"]["P08"] = GP08.read();
    WIZwikiREST["GPIOs"]["P08"].accessible = true;
    WIZwikiREST["GPIOs"]["P08"].cb_action = p8_set;
    WIZwikiREST["GPIOs"]["P09"] = GP09.read();
    WIZwikiREST["GPIOs"]["P09"].accessible = true;
    WIZwikiREST["GPIOs"]["P09"].cb_action = p9_set;
    WIZwikiREST["GPIOs"]["P10"] = GP10.read();
    WIZwikiREST["GPIOs"]["P10"].accessible = true;
    WIZwikiREST["GPIOs"]["P10"].cb_action = p10_set;
    WIZwikiREST["GPIOs"]["P11"] = GP11.read();
    WIZwikiREST["GPIOs"]["P11"].accessible = true;
    WIZwikiREST["GPIOs"]["P11"].cb_action = p11_set;
    WIZwikiREST["GPIOs"]["P12"] = GP12.read();
    WIZwikiREST["GPIOs"]["P12"].accessible = true;
    WIZwikiREST["GPIOs"]["P12"].cb_action = p12_set;
    WIZwikiREST["GPIOs"]["P13"] = GP13.read();
    WIZwikiREST["GPIOs"]["P13"].accessible = true;
    WIZwikiREST["GPIOs"]["P13"].cb_action = p13_set;
    WIZwikiREST["GPIOs"]["P14"] = GP14.read();
    WIZwikiREST["GPIOs"]["P14"].accessible = true;
    WIZwikiREST["GPIOs"]["P14"].cb_action = p14_set;
    WIZwikiREST["GPIOs"]["P15"] = GP15.read();
    WIZwikiREST["GPIOs"]["P15"].accessible = true;
    WIZwikiREST["GPIOs"]["P15"].cb_action = p15_set;
    WIZwikiREST["GPIOs"]["P16"] = GP16.read();
    WIZwikiREST["GPIOs"]["P16"].accessible = true;
    WIZwikiREST["GPIOs"]["P16"].cb_action = p16_set;
    WIZwikiREST["GPIOs"]["P17"] = GP17.read();
    WIZwikiREST["GPIOs"]["P17"].accessible = true;
    WIZwikiREST["GPIOs"]["P17"].cb_action = p17_set;
    WIZwikiREST["GPIOs"]["P18"] = GP18.read();
    WIZwikiREST["GPIOs"]["P18"].accessible = true;
    WIZwikiREST["GPIOs"]["P18"].cb_action = p18_set;
    WIZwikiREST["GPIOs"]["P19"] = GP19.read();
    WIZwikiREST["GPIOs"]["P19"].accessible = true;
    WIZwikiREST["GPIOs"]["P19"].cb_action = p19_set;
    WIZwikiREST["GPIOs"]["P20"] = GP20.read();
    WIZwikiREST["GPIOs"]["P20"].accessible = true;
    WIZwikiREST["GPIOs"]["P20"].cb_action = p20_set;
    WIZwikiREST["GPIOs"]["P21"] = GP21.read();
    WIZwikiREST["GPIOs"]["P21"].accessible = true;
    WIZwikiREST["GPIOs"]["P21"].cb_action = p21_set;
    WIZwikiREST["GPIOs"]["P22"] = GP22.read();
    WIZwikiREST["GPIOs"]["P22"].accessible = true;
    WIZwikiREST["GPIOs"]["P22"].cb_action = p22_set;
    
    WIZwikiREST["GPIOs"]["P23"] = GP23.read();
    WIZwikiREST["GPIOs"]["P23"].accessible = true;
    WIZwikiREST["GPIOs"]["P23"].cb_action = p23_set;
    WIZwikiREST["GPIOs"]["P24"] = GP24.read();
    WIZwikiREST["GPIOs"]["P24"].accessible = true;
    WIZwikiREST["GPIOs"]["P24"].cb_action = p24_set;
    WIZwikiREST["GPIOs"]["P25"] = GP25.read();
    WIZwikiREST["GPIOs"]["P25"].accessible = true;
    WIZwikiREST["GPIOs"]["P25"].cb_action = p25_set;
    WIZwikiREST["GPIOs"]["P26"] = GP26.read();
    WIZwikiREST["GPIOs"]["P26"].accessible = true;
    WIZwikiREST["GPIOs"]["P26"].cb_action = p26_set;
    WIZwikiREST["GPIOs"]["P27"] = GP27.read();
    WIZwikiREST["GPIOs"]["P27"].accessible = true;
    WIZwikiREST["GPIOs"]["P27"].cb_action = p27_set;
    WIZwikiREST["GPIOs"]["P28"] = GP28.read();
    WIZwikiREST["GPIOs"]["P28"].accessible = true;
    WIZwikiREST["GPIOs"]["P28"].cb_action = p28_set;
    WIZwikiREST["GPIOs"]["P29"] = GP29.read();
    WIZwikiREST["GPIOs"]["P29"].accessible = true;
    WIZwikiREST["GPIOs"]["P29"].cb_action = p29_set;
/*    
    WIZwikiREST["GPIOs"]["P30"] = GP30.read();
    WIZwikiREST["GPIOs"]["P30"].accessible = true;
    WIZwikiREST["GPIOs"]["P30"].cb_action = p30_set;
    WIZwikiREST["GPIOs"]["P31"] = GP31.read();
    WIZwikiREST["GPIOs"]["P31"].accessible = true;
    WIZwikiREST["GPIOs"]["P31"].cb_action = p31_set;
    WIZwikiREST["GPIOs"]["P32"] = GP32.read();
    WIZwikiREST["GPIOs"]["P32"].accessible = true;
    WIZwikiREST["GPIOs"]["P32"].cb_action = p32_set;
*/
    debug_info();
}
