#include "mbed.h"
#include "HTTPServer.h"
#include "RequestHandler.h"
#include "EthernetInterface.h"
#include "MbedJSONValue.h"

#define SERVER_PORT 80

EthernetInterface eth;
HTTPServer WIZwikiWebSvr;
MbedJSONValue WIZwikiREST;

// Enter a MAC address for your controller below.
uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0xFE};
char mac_str[20];
char ip_addr[] = "192.168.100.100";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "192.168.100.1";

DigitalOut LED_1(PA_1);
DigitalOut LED_2(PA_2);

DigitalInOut P05(P5);
DigitalInOut P06(P6);

void WIZwiki_REST_init();

int main(void)
{
    sprintf(mac_str, "%02X:%02X:%02X:%02X:%02X:%02X",mac_addr[0],mac_addr[1],
                                                     mac_addr[2],mac_addr[3], 
                                                     mac_addr[4],mac_addr[5]);
    //GPIO Set
    P05.output();
    P05.write(1);
    P06.input();
    
    //LED Setbit
    LED_1.write(0); // LED On
    LED_2.write(1); // LED Off

    WIZwiki_REST_init();
                
    // Serialize it into a JSON string
    printf("\r\n");
    printf("-------------------------WIZwikiREST--------------------------- \r\n");
    printf("%s\r\n", WIZwikiREST.serialize().c_str());
    printf("--------------------------------------------------------------- \r\n");

    WIZwikiWebSvr.add_request_handler("GET", new GetRequestHandler());
    //WIZwikiWebSvr.add_request_handler("DELETE", new DeleteRequestHandler());
    //WIZwikiWebSvr.add_request_handler("PUT", new PutRequestHandler());
    
    #ifdef DHCP
        eth.init(mac_addr); //Use DHCP
    #else
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif
    
    printf("Check Ethernet Link\r\n");
    
    while(1) //Wait link up
    {
        if(eth.link() == true) 
        break;
    }
    
    printf("Link up\r\n");
    printf("IP Address is %s\r\n", eth.getIPAddress());

    if(!WIZwikiWebSvr.init(SERVER_PORT))
    {
        eth.disconnect();
        return -1;
    }

    while(1)
    {
        WIZwikiWebSvr.run();
    }
}

void WIZwiki_REST_init(void)
{
    //Fill the object
    WIZwikiREST["Name"] = "WIZwiki-REST-01";
    //Network
    WIZwikiREST["Network"]["MAC"] = mac_str;
    WIZwikiREST["Network"]["IP"] = ip_addr; 
    WIZwikiREST["Network"]["SN"] = subnet_mask;  
    WIZwikiREST["Network"]["GW"] = gateway_addr;
    //LEDs
    WIZwikiREST["LEDs"]["LED_1"]["Value"] = (LED_1.read() ? "Off" : "On");
    WIZwikiREST["LEDs"]["LED_2"]["Value"] = (LED_2.read() ? "Off" : "On");
    
    // GPIOs
    WIZwikiREST["GPIOs"]["P05"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_5) ? "Output" : "Input");
    WIZwikiREST["GPIOs"]["P05"]["Value"] = (P05.read() ? "1" : "0");
    WIZwikiREST["GPIOs"]["P06"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_6) ? "Output" : "Input");
    WIZwikiREST["GPIOs"]["P06"]["Value"] = (P06.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P07"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_7) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P07"]["Value"] = (P07.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P08"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_8) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P08"]["Value"] = (P08.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P09"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_9) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P09"]["Value"] = (P09.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P10"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_10) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P10"]["Value"] = (P10.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P11"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_11) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P11"]["Value"] = (P11.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P12"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_12) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P12"]["Value"] = (P12.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P13"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_13) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P13"]["Value"] = (P13.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P14"]["Mode"] = ((GPIOA->OUTENSET&GPIO_Pin_14) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P14"]["Value"] = (P14.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P15"]["Mode"] = ((GPIOB->OUTENSET&GPIO_Pin_0) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P15"]["Value"] = (P15.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P16"]["Mode"] = ((GPIOB->OUTENSET&GPIO_Pin_1) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P16"]["Value"] = (P16.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P17"]["Mode"] = ((GPIOB->OUTENSET&GPIO_Pin_2) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P17"]["Value"] = (P17.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P18"]["Mode"] = ((GPIOB->OUTENSET&GPIO_Pin_3) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P18"]["Value"] = (P18.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P19"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_8) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P19"]["Value"] = (P19.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P20"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_4) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P20"]["Value"] = (P20.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P21"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_0) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P21"]["Value"] = (P21.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P22"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_1) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P22"]["Value"] = (P22.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P23"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_2) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P23"]["Value"] = (P23.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P24"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_3) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P24"]["Value"] = (P24.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P25"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_9) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P25"]["Value"] = (P25.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P26"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_5) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P26"]["Value"] = (P26.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P27"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_12) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P27"]["Value"] = (P27.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P28"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_13) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P28"]["Value"] = (P28.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P29"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_14) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P29"]["Value"] = (P29.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P30"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_15) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P30"]["Value"] = (P30.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P31"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_6) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P31"]["Value"] = (P31.read() ? "1" : "0");
//  WIZwikiREST["GPIOs"]["P32"]["Mode"] = ((GPIOC->OUTENSET&GPIO_Pin_7) ? "Output" : "Input");
//  WIZwikiREST["GPIOs"]["P32"]["Value"] = (P32.read() ? "1" : "0");
}
