#ifndef HTTP_SERVER
#define HTTP_SERVER

#include <map>

#include "mbed.h"
#include <string>
#include "RequestHandler.h"
#include "EthernetInterface.h"

#define DEBUG_HTTP

typedef enum _HTTP_RESULT
{
    HTTP_INVALID_URI    = -3,
    HTTP_INVALID_DATA   = -2,
    HTTP_INVALID_HANDLE = -1,
    HTTP_SUCCESS        =  1
}HTTP_RESULT;


static  char HTTPBUF[600] = {0,};
static  char rest_result[300] = {0,};

class HTTPServer
{
    public :
    
        HTTPServer();
        virtual ~HTTPServer();
        
        bool init(int port);

        void run();
        
        void add_request_handler(char *name, RequestHandler* handler);
        
    private :

        HTTP_RESULT handle_request(char *buffer);
        
        TCPSocketServer socket;
        std::map<char*, RequestHandler*, bool(*)(char*, char*)> handlers;
                //char rest_result[2048];

};

#endif

