#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "RequestHandler.h"
#include "MbedJSONValue.h"

extern MbedJSONValue WIZwikiREST;

MbedJSONValue*    pDataJson = 0;

void GetRequestHandler::handle(char* rest_uri, char* request_data, char *reply)
{
    MbedJSONValue* tmpJson;

      char* tok;
      char* last;
      const char * pchar = 0;
#ifdef DEBUG_HTTPREQ
    printf("GetRequestHandler():%s\r\n",rest_uri);
#endif    
    if(!strcmp(rest_uri, "/")){
        tmpJson = &WIZwikiREST;     
    }
    else{
        tok = strtok_r(rest_uri+1, "/", &last);
        tmpJson = &WIZwikiREST;
        
        char* name = 0;
        while(tok)
        {
#ifdef DEBUG_HTTPREQ            
            printf("tok = %s \r\n", tok);
#endif            
            if(tmpJson->hasMember(tok)){
                tmpJson = &((*tmpJson)[tok]);
                name = tok;
                tok = strtok_r(0, "/", &last);
            }
            else{
#ifdef DEBUG_HTTPREQ                
                printf("No Member\r\n");
#endif                
                break;
            }
        }
        if(name){
            if(tok){
                if(tmpJson->accessible){
#ifdef DEBUG_HTTPREQ                    
                    printf("accessible : tmpJson->size()=%d\r\n",tmpJson->size());
#endif                    
                    
                    if(tmpJson->size() > 0){
                        *tmpJson = std::string(tok); 
                        tmpJson->cb_action((void*)tok); 
#ifdef DEBUG_HTTPREQ                        
                        printf("set string:%s\r\n",tok);
#endif
                    }
                    else{
                        *tmpJson = atoi(tok); 
                        tmpJson->cb_action(&tmpJson->_value); 
#ifdef DEBUG_HTTPREQ                        
                        printf("set int:%d\r\n",atoi(tok));
#endif                        
                    }
                }
                else{
                    strcpy (reply, "HTTP/1.1 403 OK\r\n");
                    strcat (reply, "Sever: WIZwiki-REST\r\n");
                    strcat (reply, "content-Type: text/json\r\n");
                    sprintf(reply + strlen(reply), "Content-Length: %d\r\n\r\n", 26+4);
                    strcat(reply, "{\"Result : No Accessible\"}");
                    strcat (reply, "\r\n\r\n");
                    return;
                }
            }
        }
        else{
            strcpy (reply, "HTTP/1.1 404 OK\r\n");
            strcat (reply, "Sever: WIZwiki-REST\r\n");
            strcat (reply, "content-Type: text/json\r\n");
            sprintf(reply + strlen(reply), "Content-Length: %d\r\n\r\n", 33+4);
            strcat(reply, "{\"Result\" : \"No defined Resource\"}");
            strcat (reply, "\r\n\r\n");
            return;
        }
    }
    pchar = (*tmpJson).serialize().c_str();
    strcpy (reply, "HTTP/1.1 200 OK\r\n");
    strcat (reply, "Sever: WIZwiki-REST\r\n");
    strcat (reply, "content-Type: text/json\r\n");
    sprintf(reply + strlen(reply), "Content-Length: %d\r\n\r\n", strlen(pchar)+4);
    strcat (reply, pchar);
    strcat (reply, "\r\n\r\n");

    return;
}

void PostRequestHandler::handle(char* rest_uri, char* request_data, char *reply)
{
    MbedJSONValue* tmpJson;
      char* tok;
      char* last;
      int errnum = 200;
      
#ifdef DEBUG_HTTPREQ
    printf("PostRequestHandler():%s\r\n",request_data+4);
#endif
    if(!pDataJson){
        pDataJson = new MbedJSONValue();  
    }
#ifdef DEBUG_HTTPREQ
    printf("Before Parse\r\n");
    debug_info();
#endif
    parse(*pDataJson,(const char*)request_data);
#ifdef DEBUG_HTTPREQ
    printf("After Parse\r\n");
    debug_info();
    printf("DataJson._type=%d\r\n",pDataJson->_type);
    printf("DataJson=%s\r\n",pDataJson->serialize().c_str());
    printf("DataJson.size()=%d\r\n",pDataJson->size());
    printf("DataJason.type=%d\r\n",pDataJson->_type);
#endif    

    if(!strcmp(rest_uri, "/")){
        tmpJson = &WIZwikiREST;     
    }
    else{
        tok = strtok_r(rest_uri+1, "/", &last);
        tmpJson = &WIZwikiREST;
        
        char* name = 0;
        while(tok)
        {
#ifdef DEBUG_HTTPREQ            
            printf("tok = %s \r\n", tok);
#endif            
            if(tmpJson->hasMember(tok)){
                tmpJson = &((*tmpJson)[tok]);
                name = tok;
                tok = strtok_r(0, "/", &last);
            }
            else{
#ifdef DEBUG_HTTPREQ                
                printf("No Member\r\n");
#endif                
                break;
            }
        }
        if(name){
#ifdef DEBUG_HTTPREQ                            
            printf("Token_name=%s\r\n",name);
#endif
            if(tok){
#ifdef DEBUG_HTTPREQ                                            
                printf("It should be no parameters : tok=%s\r\n",tok);
#endif                
                errnum = 403;
            }
        }
        else{
            errnum = 404;
        }
    }
    if(errnum != 0){
        switch(pDataJson->_type)
        {
            case MbedJSONValue::TypeInt:
                if(tmpJson->accessible){
                    *tmpJson = pDataJson->_value.asInt; 
                    tmpJson->cb_action(&tmpJson->_value); 
#ifdef DEBUG_HTTPREQ                        
                    printf("set int:%d\r\n",atoi(tok));
#endif                        
                }
                else{
                    errnum = 403;
                }
                break;
                
            case MbedJSONValue::TypeString:
                if(tmpJson->accessible){
                    *tmpJson = pDataJson->_value.asString;
                    tmpJson->cb_action((void*)tmpJson->_value.asString->c_str()); 
                }
                else{
                    errnum = 403;
                }
                break;
                
            case MbedJSONValue::TypeObject:
                for(int i = 0; i < pDataJson->index_token; i++)
                {
                    tok = (char*)pDataJson->token_name[i]->c_str();
#ifdef DEBUG_HTTPREQ                                                
                    printf("pDataJson.token_name[%d]->c_str()=%s\r\n",i,tok);
#endif                    
                    if(tmpJson->hasMember(tok)){
                        if((*tmpJson)[tok].accessible){
                            errnum = 200;
                            if((*pDataJson)[i].size() > 0){
                                //(*tmpJson)[tok] = (*pDataJson)[i]._value.asString;
                                (*tmpJson)[tok] = (*pDataJson)[i]._value.asString->c_str();
                                
                                //(*tmpJson)[tok].cb_action((void*)&((*pDataJson)[i]._value.asInt)); 
                                (*tmpJson)[tok].cb_action((void*)((*pDataJson)[i]._value.asString->c_str())); 
#ifdef DEBUG_HTTPREQ                                                            
                                printf("String Updated: %s : %s\r\n", tok,(*tmpJson)[tok].get<std::string>().c_str());
#endif                                
                            }
                            else{
                                (*tmpJson)[tok] = (*pDataJson)[i]._value.asInt;
                                (*tmpJson)[tok].cb_action((void*)&((*pDataJson)[i]._value.asInt)); 
#ifdef DEBUG_HTTPREQ
                                printf("Int Updated: %s : %d\r\n", tok,(*tmpJson)[tok].get<int>());
#endif                                
                            }
                        }
                        else{
                            errnum = 403; break;
                        }
                    }
                    else{
                        errnum = 404; break;
                    }
                }
                break;
                
            default:
                errnum = 403; break;
        }    
    }
        
    switch(errnum)
    {
        case 403:
                strcpy (reply, "HTTP/1.1 403 OK\r\n");
                strcat (reply, "Sever: WIZwiki-REST\r\n");
                strcat (reply, "content-Type: text/json\r\n");
                sprintf(reply + strlen(reply), "Content-Length: %d\r\n\r\n", 26+4);
                strcat(reply, "{\"Result : No Accessible\"}");
                strcat (reply, "\r\n\r\n");
                break;
            
        case 404:
                strcpy (reply, "HTTP/1.1 404 OK\r\n");
                strcat (reply, "Sever: WIZwiki-REST\r\n");
                strcat (reply, "content-Type: text/json\r\n");
                sprintf(reply + strlen(reply), "Content-Length: %d\r\n\r\n", 33+4);
                strcat(reply, "{\"Result\" : \"No defined Resource\"}");
                strcat (reply, "\r\n\r\n");
                break;
            
        case 200:
                strcpy (reply, "HTTP/1.1 200 OK\r\n");
                strcat (reply, "Sever: WIZwiki-REST\r\n");
                strcat (reply, "content-Type: text/json\r\n");
                sprintf(reply + strlen(reply), "Content-Length: %d\r\n\r\n", 15+4);
                strcat (reply, "{\"Result\":\"OK\"}");
                strcat (reply, "\r\n\r\n");
                break;
    }
    
#ifdef DEBUG_HTTPREQ
    printf("Before Delete\r\n");
    debug_info();
#endif
    if(pDataJson){
#ifdef DEBUG_HTTPREQ
        printf("type;%d, pDataJson->index_token=%d\r\n",pDataJson->_type,pDataJson->index_token);
#endif
        delete pDataJson;
        pDataJson = 0;
    }
#ifdef DEBUG_HTTPREQ
    printf("After Delete\r\n");
    debug_info();
#endif
}

/*
void PutRequestHandler::handle(char* rest_uri, char* request_data, char *reply)
{
}

void DeleteRequestHandler::handle(char* rest_uri, char* request_data, char *reply)
{
}
*/