#include "mbed.h"
#include "HTTPServer.h"
#include "RequestHandler.h"
#include "EthernetInterface.h"
#include "MbedJSONValue.h"
#include "DHT.h"

#define SERVER_PORT 80
//#define DHCP


//-- GPIO LED --
DigitalOut GP09(D9);
DigitalOut GP10(D10);
DigitalOut GP11(D11);

//-- ADC --
AnalogIn   ain(A0);

//-- DHT --
DHT sensor(D4, DHT11);


EthernetInterface eth;
HTTPServer WIZwikiWebSvr;
MbedJSONValue WIZwikiREST;

GetRequestHandler  myGetReq;
//PostRequestHandler myPostReq;
PutRequestHandler  myPutReq;

// Enter a MAC address for your controller below.
uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0xFE};
char mac_str[20];
char ip_addr[]      = "192.168.100.100";
char subnet_mask[]  = "255.255.255.0";
char gateway_addr[] = "192.168.100.1";

float c = 0.0f, h = 0.0f;


//-- GPIO --
bool p9_set(void* param)
{
    if(!param) return false;
    GP09.write(*(int*)param);
    return true;
}
bool p10_set(void* param)
{
    if(!param) return false;
    GP10.write(*(int*)param);
    return true;
}
bool p11_set(void* param)
{
    if(!param) return false;
    GP11.write(*(int*)param);
    return true;
}

//-- ADC --
bool ain_read(void* param)
{
    ((MbedJSONValue*)param)->_value.asDouble = ain.read();
    return true;
}

//-- DHT --
bool tmp_read(void* param)
{  
    wait(0.5);
    ((MbedJSONValue*)param)->_value.asDouble = (sensor.readData()==0) ?  sensor.ReadTemperature(CELCIUS) : 0;
    return true;
}
bool hum_read(void* param)
{   
    wait(0.5);
    ((MbedJSONValue*)param)->_value.asDouble = (sensor.readData()==0) ?  sensor.ReadHumidity() : 0;
    return true;
}
 

void WIZwiki_REST_init();

int main(void)
{

    sprintf(mac_str, "%02X:%02X:%02X:%02X:%02X:%02X",mac_addr[0],mac_addr[1],mac_addr[2],mac_addr[3],mac_addr[4],mac_addr[5]);

    WIZwiki_REST_init();
                    
    // Serialize it into a JSON string
    printf("---------------------WIZwikiREST-------------------- \r\n");
    printf("\r\n%s\r\n", WIZwikiREST.serialize().c_str());
    printf("---------------------------------------------------- \r\n");

    WIZwikiWebSvr.add_request_handler("GET", &myGetReq);
    //WIZwikiWebSvr.add_request_handler("POST", &myPostReq);
    WIZwikiWebSvr.add_request_handler("PUT", &myPutReq);
    //WIZwikiWebSvr.add_request_handler("DELETE", new PostRequestHandler());
    
    #ifdef DHCP
        eth.init(mac_addr); //Use DHCP
    #else
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif
    
    
    printf("Check Ethernet Link\r\n");
    
    do{
        printf("   Link - Wait... \r\n");
        wait(1);
    }while(!eth.ethernet_link());
    printf("-- Ethetnet PHY Link - Done -- \r\n");
        
    if (eth.connect() < 0 )
        printf("-- EThernet Connect - Fail -- \r\n");
    else
    {
        printf("-- Assigned Network Information -- \r\n");
        printf("   IP   : %s\r\n\r\n", eth.getIPAddress()); 
        printf("   MASK : %s\r\n\r\n", eth.getNetworkMask());
        printf("   GW   : %s\r\n\r\n", eth.getGateway());
    }
    
    printf("Link up\r\n");
    printf("IP Address is %s\r\n", eth.getIPAddress());


    if(!WIZwikiWebSvr.init(SERVER_PORT))
    {
        eth.disconnect();
        return -1;
    }

    while(1)
    {
        WIZwikiWebSvr.run();
    }
}

void WIZwiki_REST_init(void)
{
    //Fill the object
    WIZwikiREST["Name"] = "WIZwikiREST-io WIZnet Academy";
    WIZwikiREST["Name"].accessible = false;
    
    //Network
    WIZwikiREST["Network"]["MAC"] = mac_str;
    WIZwikiREST["Network"]["IP"] = ip_addr; 
    WIZwikiREST["Network"]["IP"].accessible = true; 
    WIZwikiREST["Network"]["SN"] = subnet_mask;  
    WIZwikiREST["Network"]["SN"].accessible = true;  
    WIZwikiREST["Network"]["GW"] = gateway_addr;
    WIZwikiREST["Network"]["GW"].accessible = true;
   
    // GPIO
    WIZwikiREST["GPIOs"]["P09"] = 0;
    WIZwikiREST["GPIOs"]["P09"].accessible = true;
    WIZwikiREST["GPIOs"]["P09"].cb_action = p9_set;
    WIZwikiREST["GPIOs"]["P10"] = 0;
    WIZwikiREST["GPIOs"]["P10"].accessible = true;
    WIZwikiREST["GPIOs"]["P10"].cb_action = p10_set;
    WIZwikiREST["GPIOs"]["P11"] = 0;
    WIZwikiREST["GPIOs"]["P11"].accessible = true;
    WIZwikiREST["GPIOs"]["P11"].cb_action = p11_set;
    
    // ADC
    WIZwikiREST["ADC"]["A0"] = 0.0f;
    WIZwikiREST["ADC"]["A0"].accessible = false;
    WIZwikiREST["ADC"]["A0"].cb_action = ain_read;
    
    // DHT11
    WIZwikiREST["DHT"]["tmp"] = 0.0f;
    WIZwikiREST["DHT"]["tmp"].accessible = false;
    WIZwikiREST["DHT"]["tmp"].cb_action = tmp_read;
    WIZwikiREST["DHT"]["hum"] = 0.0f;
    WIZwikiREST["DHT"]["hum"].accessible = false;
    WIZwikiREST["DHT"]["hum"].cb_action = hum_read;
    
}
