
#include "mbed.h"
#include "EthernetInterface.h"
#include "GPS.h"

GPS gpsAda(D1, D0, 9600);

InterruptIn mysw(D7);
DigitalOut myled1(LED3);

#define TOKEN "3252156354-fG0b1utXYAg5IqeJNMSJFlenx1rgSRXm5wgk21l"

void exin() {
    
    int phy_link;
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x03, 0x04, 0x02}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    
    while(1){
        
    eth.connect();
    
    /* phy link */
     do{
        phy_link = eth.ethernet_link();
        printf("...");
        wait(2);
     }while(!phy_link);
    printf("\r\n");
     
    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    
    /* TCP socket connect */
    TCPSocketConnection sock;
    sock.connect("arduino-tweet.appspot.com", 80);
    
    printf("connected\r\n");
   
    float longi = 0;
    float latit = 0;
    int time;
    
    char message1[] = "Alert!!\r\nSunae-Station";
    char message2[] = "\r\nTime:";
    
    char message[36] = {0};
    
    /* get gps data */
    if(gpsAda.sample()) 
    {      
        longi = gpsAda.longitude;
        latit = gpsAda.latitude;
        time = gpsAda.time + 90000; 
//       printf("%f,%f,%d\r\n\r\n",longi,latit,time);
    }
    
    /* gps time data */
    char time_data[6]={0};
    int hour10 = 0;
    int hour1 = 0;
    int min10 = 0;
    int min1 = 0;
    int sec10 = 0;
    int sec1 = 0;

    hour10 = time/100000;
    hour1 = (time-hour10*100000)/10000;
    min10 = (time-hour10*100000-hour1*10000)/1000;
    min1 = (time-hour10*100000-hour1*10000-min10*1000)/100;
    sec10 = (time-hour10*100000-hour1*10000-min10*1000-min1*100)/10;
    sec1 = time-hour10*100000-hour1*10000-min10*1000-min1*100-sec10*10;
    
    time_data[5] = sec1 + 48;
    time_data[4] = sec10 + 48;
    time_data[3] = min1 + 48;
    time_data[2] = min10 + 48;
    time_data[1] = hour1 + 48;
    time_data[0] = hour10 + 48;

//    printf("%s\r\n",time_data);

    
    /* gps location data, time data on message */
    if((longi> 27.109287)&&(longi<127.120232))
    {
        if((latit>37.374869)&&(latit<37.381587))
        {
//            printf("alright\r\n");
            sprintf(message, "%s%s%s", message1, message2, time_data);
        }else{
            sprintf(message, "%s%s%s", message1, message2, time_data);
        }
    }else{
        sprintf(message, "%s%s%s", message1, message2, time_data);
    }

    //sprintf(message, "%s%s%s", message1, message2, time_data);

    /* data length measure */
    char data_len[2]={0};
    int ten=0;
    int one=0;
    
    int length = sizeof(message) - 1 + sizeof(TOKEN) - 1 + 14;
    
//    printf("%d\r\n\r\n",length);
    
    ten = length/10;
    one = length%10;
    data_len[1] = one + 48;
    data_len[0] = ten + 48;

    /* send message on format data to proxy server */
    char *cmd1 = "POST http://arduino-tweet.appspot.com/update HTTP/1.0\r\nContent-Length:";
    char *cmd2 = data_len;
    char *cmd3 = "\r\n\r\ntoken=";
    char *cmd4 = TOKEN;
    char *cmd5 = "&status=";
    char *cmd6 = message;
    char *cmd7 = "\r\n";
    
    char send_data[1024];
    sprintf(send_data, "%s%s%s%s%s%s%s", cmd1, cmd2, cmd3, cmd4, cmd5, cmd6, cmd7);

    sock.send_all(send_data, sizeof(send_data)-1);
    
    printf("%s\r\n",send_data);
    printf("send message done\r\n");
    
    /* receive data from server */
    char buffer[1024];
    
    sock.receive(buffer, sizeof(buffer)-1); 
    printf("%s\r\n",buffer);
    
    /* sock close */
    sock.close();
    
    eth.disconnect();
    
    wait(70.0);
    
    };

}

int main() {
    
    printf("Run now...\r\n");
    
    mysw.rise(&exin);
    
    while(1) {   
        myled1 = !myled1;
        wait(1.0);
    } 
}

 

/*
#include "mbed.h"
#include "EthernetInterface.h"

#define TOKEN "3252156354-fG0b1utXYAg5IqeJNMSJFlenx1rgSRXm5wgk21l"

int main()
{

    int phy_link;
    printf("wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x03, 0x04, 0x02};

    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP

    while(1) {

        eth.connect();

         phy link 
        do {
            phy_link = eth.ethernet_link();
            printf("...");
            wait(2);
        } while(!phy_link);
        printf("\r\n");

        printf("IP Address is %s\r\n", eth.getIPAddress());

         TCP socket connect 
        TCPSocketConnection sock;
        sock.connect("arduino-tweet.appspot.com", 80);

        printf("connected\r\n");

        char message[] = "test1234";

        char len[10];
        char str[10];

        int length = sizeof(message) - 1 + sizeof(TOKEN) - 1 + 14;

        printf("%d\r\n",length);

          
        char *cmd1 = "POST http://arduino-tweet.appspot.com/update HTTP/1.0\r\nContent-Length:";
        char *cmd2 = "72";
        char *cmd3 = "\r\n\r\ntoken=";
        char *cmd4 = TOKEN;
        char *cmd5 = "&status=";
        char *cmd6 = message;
        char *cmd7 = "\r\n";


        char send_data[1024];
        char buffer[1024];
        sprintf(send_data, "%s%s%s%s%s%s%s", cmd1, cmd2, cmd3, cmd4, cmd5, cmd6, cmd7);

        sock.send_all(send_data, sizeof(send_data)-1);

        printf("%s\r\n",send_data);
        printf("send message done\r\n");

        sock.receive(buffer, sizeof(buffer)-1);

        printf("%s\r\n",buffer);

        sock.close();

        eth.disconnect();

        wait(70.0);

    };

}

*/