#include "mbed.h"
#include "EthernetInterface.h"

// Declare Ethernet Class
EthernetInterface eth;

// Declare Server Class
TCPSocketServer server;

// Declare Client Class
TCPSocketConnection client;

//Set Server Network
uint8_t echo_server_mac[] = {0x00, 0x08, 0xDC, 0xFF, 0xFF, 0xD2};
char echo_server_ip[] = "192.168.0.100";
char echo_server_subnet[] = "255.255.255.0";
char echo_server_gateway[] = "192.168.0.1";
int echo_server_port = 30000;

//Close message
char close_message[256] = "close";

int main (void) 
{
    printf("Wait a second...\r\n");
    eth.init(echo_server_mac, echo_server_ip, echo_server_subnet, echo_server_gateway);
    eth.connect();
    
    printf("Server MAC Address     is %s\r\n", eth.getMACAddress());
    printf("Server IP Address      is %s\r\n", eth.getIPAddress());
    printf("Server SUBNET Address  is %s\r\n", eth.getNetworkMask());
    printf("Server GATEWAY Address is %s\r\n", eth.getGateway());
    
    server.bind(echo_server_port);
    server.listen();
    
    while (true) 
    {
        printf("Wait for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            buffer[n] = '\0';
            
            if (strcmp(buffer,close_message)==0) {
                printf("recv close message \r\n"); 
                break;
                }
            else {
                if (n > 0) {    
                    // print received message to terminal
                    printf("Received message from Client :'%s'\r\n",buffer);
                        
                    // print sending message to terminal
                    printf("Sending message to Client: '%s'\r\n",buffer);
            
                    // Echo received message back to client
                    client.send_all(buffer, n);
                }
            }
        }
        
        client.close();
    }
    
}

