//#include "mbed.h"
//#include "EthernetInterface.h"
//#include "MbedJSONValue.h"

/*
MbedJSONValue parser;
EthernetInterface eth;
TCPSocketConnection sock;

int main()
{
    int http_tx_msg_sz=800;
    char http_tx_msg[http_tx_msg_sz];
    int http_rx_msg_sz=500;
    char http_rx_msg[http_rx_msg_sz];
    int returnCode = 0;

    // Enter a MAC address for your controller below.
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};

    printf("initializing Ethernet\r\n");
    // initializing MAC address
    eth.init(mac_addr, "192.168.0.34", "255.255.255.0", "192.168.0.1");

    // Check Ethenret Link
    if(eth.link() == true)   printf("- Ethernet PHY Link-Done \r\n");
    else printf("- Ethernet PHY Link- Fail\r\n");

    // Start Ethernet connecting: Trying to get an IP address using DHCP
    if (eth.connect()<0)    printf("Fail - Ethernet Connecing");

    // Print your local IP address:
    printf("IP=%s\n\r",eth.getIPAddress());
    printf("MASK=%s\n\r",eth.getNetworkMask());
    printf("GW=%s\n\r",eth.getGateway());

    while(1) {
        sock.connect("192.168.0.223", 8000);

        snprintf(http_tx_msg, http_tx_msg_sz,  "GET / HTTP/1.1\r\nHost: 192.168.0.223:8000\r\nUser-Agent: WIZwiki-W7500ECO\r\nConection: close\r\n\r\n");
        sock.send_all(http_tx_msg, http_tx_msg_sz-1);

        while ( (returnCode = sock.receive(http_rx_msg, http_rx_msg_sz-1)) > 0) {
            http_rx_msg[returnCode] = '\0';
            printf("Received %d chars from server:\n\r%s\n", returnCode, http_rx_msg);
        }

        sock.close();

        parse(parser, http_rx_msg);
        printf("name =%s\r\n" , parser["name"].get<string>().c_str());
        printf("age =%d\r\n" , parser["age"].get<int>());
        printf("gender =%s\r\n" , parser["gender"].get<string>().c_str());

        wait(10);
    }

}
*/


#include "mbed.h"
#include "EthernetInterface.h"
#include "MbedJSONValue.h"


EthernetInterface eth;
TCPSocketConnection sock;

MbedJSONValue WIZwikiREST;
MbedJSONValue GPIOs;

char ip_addr[] = "192.168.0.100";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "192.168.0.1";
  
int main() {          
  
    std::string s;
      
    // Fill the object
    WIZwikiREST["Name"] = "WIZwiki-REST-01";
    WIZwikiREST["Network"]["IP"] = ip_addr;
    WIZwikiREST["Network"]["SN"] = subnet_mask;  
    WIZwikiREST["Network"]["GW"] = gateway_addr;
    WIZwikiREST["User"]["Name"] = "Lawrence";
    WIZwikiREST["User"]["ID"] = "law";
    WIZwikiREST["User"]["PSWD"] = "law1234";
    GPIOs["P5"]["Mode"] = "DIO";
    GPIOs["P6"]["Mode"] = "DIO";
    WIZwikiREST["GPIOs"] = GPIOs;
      
      
    // Serialize it into a JSON string
    s = WIZwikiREST.serialize();
    printf("json: %s\r\n", s.c_str());
    string item = "Name";
    printf("WIZwikiREST[item] =%s", WIZwikiREST[item].get<string>().c_str());

    
    int http_tx_msg_sz=800;
    char http_tx_msg[http_tx_msg_sz];
    int http_rx_msg_sz=500;
    char http_rx_msg[http_rx_msg_sz];
    int returnCode = 0;

    // Enter a MAC address for your controller below.
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0xFE};

    // initializing MAC address
    printf("initializing Ethernet\r\n");
    eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr);

    // Check Ethernet Link
    printf("Check Ethernet Link\r\n");
    while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }
    printf("Link up\r\n");

    // Connect
    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());

    if (!svr.start(80, &eth)) {

        error("Server not starting !");
        exit(0);
    }

    while(1) {
        svr.poll();
    }

/*
    while(1) {
        sock.connect("192.168.0.223", 8000);

        snprintf(http_tx_msg, http_tx_msg_sz,  "GET / HTTP/1.1\r\nHost: 192.168.0.223:8000\r\nUser-Agent: WIZwiki-W7500ECO\r\nConection: close\r\n\r\n");
        sock.send_all(http_tx_msg, http_tx_msg_sz-1);

        while ( (returnCode = sock.receive(http_rx_msg, http_rx_msg_sz-1)) > 0) {
            http_rx_msg[returnCode] = '\0';
            printf("Received %d chars from server:\n\r%s\n", returnCode, http_rx_msg);
        }

        sock.close();

        parse(parser, http_rx_msg);
        printf("name =%s\r\n" , parser["name"].get<string>().c_str());
        printf("age =%d\r\n" , parser["age"].get<int>());
        printf("gender =%s\r\n" , parser["gender"].get<string>().c_str());

        wait(10);
    }
*/    

}


 
 
/** MbedJSONValue class
 *
 * Example:
 *    - creation of an MbedJSONValue of type TypeObject containing two others MbedJSONValue: 
 *         -one array of one string and one integer identified by "my_array"
 *         -a boolean identified by "my_boolean"
 *    - serialization in JSON format of this object
 * @code
 * #include "mbed.h"
 * #include "MbedJSONValue.h"
 * #include <string>
 *
 * int main() {          
 *
 *   MbedJSONValue demo;
 *   std::string s;
 *
 *   //fill the object
 *   demo["my_array"][0] = "demo_string";
 *   demo["my_array"][1] = 10;
 *   demo["my_boolean"] = false;
 *
 *   //serialize it into a JSON string
 *   s = demo.serialize();
 *   printf("json: %s\r\n", s.c_str());
 * }
 *  
 * @endcode
 *
 * Example:
 *     - creation of an MbedJSONValue from a JSON string
 *     - extraction of different values from this existing MbedJSONValue
 * @code
 * #include "mbed.h"
 * #include "MbedJSONValue.h"
 * #include <string>
 *
 * int main() {     
 *    MbedJSONValue demo;
 *
 *   const  char * json = "{\"my_array\": [\"demo_string\", 10], \"my_boolean\": true}";
 *
 *   //parse the previous string and fill the object demo
 *   parse(demo, json);
 *
 *   std::string my_str;
 *   int my_int;
 *   bool my_bool;
 *
 *   my_str = demo["my_array"][0].get<std::string>();
 *   my_int = demo["my_array"][1].get<int>();
 *   my_bool = demo["my_boolean"].get<bool>();
 *   
 *    printf("my_str: %s\r\n", my_str.c_str());
 *    printf("my_int: %d\r\n", my_int);
 *    printf("my_bool: %s\r\n", my_bool ? "true" : "false");
 * }
 * @endcode
 */