#include "MbedJSONValue.h"

# include <stdlib.h>
# include <stdio.h>

bool default_json_cb(void* param)
{
    printf("No callback function\n");
    return false;
}


// Clean up
void MbedJSONValue::clean() {
    switch (_type) {
        case TypeString:
            delete _value.asString;
            break;
        case TypeArray:
            //for (int i = 0; i < index_array; i++)
                //delete array[i];
            index_array = 0;
            break;
        case TypeObject:
            for (int i = 0; i < index_token; i++) {
                delete token[i];
                delete token_name[i];
            }
            index_token = 0;
            break;
        default:
            break;
    }
    _type = TypeNull;
    _type = TypeNull;
}

bool MbedJSONValue::hasMember(char * name)
{
    for(int i = 0; i < index_token; i++)
        if( !strcmp(name, (*(token_name[i])).c_str() ))
            return true;
    return false;
}


void copy(const std::string& s, std::back_insert_iterator<std::string> oi) {
    std::copy(s.begin(), s.end(), oi);
}

void serialize_str(const std::string& s, std::back_insert_iterator<std::string> oi) {
    *oi++ = '"';
    for (std::string::const_iterator i = s.begin(); i != s.end(); ++i) {
        switch (*i) {
#define MAP(val, sym) case val: copy(sym, oi); break
                MAP('"', "\\\"");
                MAP('\\', "\\\\");
                MAP('/', "\\/");
                MAP('\b', "\\b");
                MAP('\f', "\\f");
                MAP('\n', "\\n");
                MAP('\r', "\\r");
                MAP('\t', "\\t");
#undef MAP
            default:
                if ((unsigned char)*i < 0x20 || *i == 0x7f) {
                    char buf[7];
                    sprintf(buf, "\\u%04x", *i & 0xff);
                    copy(buf, buf + 6, oi);
                } else {
                    *oi++ = *i;
                }
                break;
        }
    }
    *oi++ = '"';
}

std::string MbedJSONValue::serialize(){
    std::string s;
    serialize(std::back_inserter(s));
    return s;
}

std::string MbedJSONValue::to_str(){
    switch (_type) {
        case TypeNull:
            return "null";
        case TypeBoolean:
            return _value.asBool ? "true" : "false";
        case TypeInt:    {
            char buf[10];
            sprintf(buf, "%d", _value.asInt);
            return buf;
        }
        case TypeDouble:    {
            char buf[10];
            sprintf(buf, "%f", _value.asDouble);
            return buf;
        }
        default:
            break;
    }
    return NULL;
}



void MbedJSONValue::serialize(std::back_insert_iterator<std::string> oi) {
    printf("SP:%X   _type=%d, index=%d\r\n",__current_sp(),_type, index_token);

    switch (_type) {
        case TypeString:
        printf("typestring\r\n");
            serialize_str(*_value.asString, oi);
            break;
        case TypeArray: {
        printf("typearray\r\n");
            *oi++ = '[';
            for (int i = 0; i < index_array; i++) {
                if (i)
                    *oi++ = ',';
                (*this)[i].serialize(oi);
            }
            *oi++ = ']';
            break;
        }
        case TypeObject: {
            printf("typeObject\r\n");
            *oi++ = '{';
            for (int i = 0; i < index_token; i++) {
                printf("i=%d ",i);
                if (i)
                    *oi++ = ',';
                printf("token_name[%d]=%s\r\n",i,token_name[i]->c_str());
                serialize_str(*(token_name[i]), oi);
                *oi++ = ':';
                (*(token[i])).serialize(oi);
            }
            *oi++ = '}';
            break;
        }
        default:
        printf("default\r\n");
            copy(to_str(), oi);
            break;
    }
}



MbedJSONValue& MbedJSONValue::operator[](int i) {
    _type = TypeArray;
    //if (i < NB_TOKEN && index_array == i ) {
    if( index_array == i){
#ifdef DEBUG
        printf("will add an element to the array\r\n");
#endif
        //array[i] = new MbedJSONValue();
        //array.push_back(new MbedJSONValue());
        token.push_back(new MbedJSONValue());
        index_array++;
        //return *(array[i]);
        return *(token[i]);
    }
    //if (i < NB_TOKEN && index_array > i)
    if(index_array > i)
//        return *(array[i]);
        return *(token[i]);

    //if the user is not doing something wrong, this code is never executed!!
    return *(new MbedJSONValue());
    //return 0;
}

MbedJSONValue& MbedJSONValue::operator[](std::string k) {
    _type = TypeObject;
    for (int i = 0; i < index_token; i++) {
#ifdef DEBUG
        printf("k: %s\r\n", k.c_str());
        printf("str: %s\r\n", token_name[i]->c_str());
#endif
        //existing token

        if (!strcmp(k.c_str(), token_name[i]->c_str())) {
#ifdef DEBUG
            printf("token found: %d\r\n", i);
#endif
            return *(token[i]);
        }
    }

    //if(index_token >= NB_TOKEN)
    //    index_token = NB_TOKEN - 1;
    //non existing token
    //token_name[index_token] = new std::string(k);
    token_name.push_back(new std::string(k));
    printf("New token_name[%d]=%X, %s\r\n", index_token, token_name[index_token], token_name[index_token]->c_str());
    //token[index_token] = new MbedJSONValue();
    token.push_back(new MbedJSONValue());
    printf("New token[%d]=%X, %d\r\n", index_token, token[index_token], token[index_token]->getType());
    index_token++;
    return *(token[index_token - 1]);
}

MbedJSONValue& MbedJSONValue::operator[](std::string k) const
{
    for (int i = 0; i < index_token; i++) {
#ifdef DEBUG
        printf("k: %s\r\n", k.c_str());
        //printf("str: %s\r\n", token_name[i]->c_str());
#endif
        printf("[%s]", k.c_str());
        printf(" comp ");
        printf("[%s]\r\n", token_name[i]->c_str());
        if (!strcmp(k.c_str(), token_name[i]->c_str())) {
#ifdef DEBUG
            printf("token found: %d\r\n", i);
#endif
            return *(token[i]);
        }
    }
    
    //if the user is not doing something wrong, this code is never executed!!
    return *(new MbedJSONValue());
    //return 0;
}


// Operators
MbedJSONValue& MbedJSONValue::operator=(MbedJSONValue const& rhs) {
    //printf("=json\r\n");
    if (this != &rhs) {
        clean();
        _type = rhs._type;
        switch (_type) {
            case TypeBoolean:
                _value.asBool = rhs._value.asBool;
                break;
            case TypeInt:
                _value.asInt = rhs._value.asInt;
                break;
            case TypeDouble:
                _value.asDouble = rhs._value.asDouble;
                break;
            case TypeString:
                  //printf("=json=%s\r\n",rhs._value.asString->c_str());
                _value.asString = new std::string(*rhs._value.asString);
                break;
            case TypeArray:
                for (int i = 0; i < rhs.index_array; i++)
                    (*this)[i] = rhs[i];
            case TypeObject:
                for (int i = 0; i < rhs.index_token; i++)
                    (*this)[*(rhs.token_name[i])] = rhs[*(rhs.token_name[i])];
            default:
                break;
        }
    }
    return *this;
}


// Works for strings, arrays, and structs.
int MbedJSONValue::size() const {
    switch (_type) {
        case TypeString:
            return int(_value.asString->size());
        case TypeArray:
            return index_array;
        case TypeObject:
            return index_token;
        default:
            break;
    }
    return -1;
}


