#include "mbed.h"
#include "EthernetInterface.h"


#define ECHO_SERVER_PORT    80      // HTTP default Port 80
char ServerName[] = "api.openweathermap.org";
char http_cmd[] = "GET /data/2.5/weather?q=Seoul,kr&appid=2a65f5f2e53b247a01a0fef6a536e50c HTTP/1.0\r\n\r\n";

#define BUFFER_SIZE  2048
char buffer[BUFFER_SIZE];


// Intitialize the Ethernet Client Library
EthernetInterface eth;    


int main() {
   
    printf("-- Welcome WIZwiki-W7500 Platform -- \r\n");

    // Enter a MAC Address for your Platform
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x03, 0x04, 0x02}; 
    
    // Initializing MAX Address
    eth.init(mac_addr);
    
    while(1) 
    {
    
        do{
            printf("   Link - Wait... \r\n");
            wait(1);
        }while(!eth.ethernet_link());
        printf("-- Ethetnet PHY Link - Done -- \r\n");
        
        if (eth.connect() < 0 )
            printf("-- EThernet Connect - Fail -- \r\n");
        else
        {
            printf("-- Assigned Network Information -- \r\n");
            printf("   IP   : %s\r\n\r\n", eth.getIPAddress()); 
            printf("   MASK : %s\r\n\r\n", eth.getNetworkMask());
            printf("   GW   : %s\r\n\r\n", eth.getGateway());
        }
        
        // Initialize the TCP Socket Connection
        TCPSocketConnection sock;
        
        if(sock.connect(ServerName, ECHO_SERVER_PORT) < 0)
            printf("-- Connect - Fail -- \r\n");
        else
        {
            printf("-- Connect - Connected -- \r\n");
            wait(3);
            while(sock.is_connected() == false)
            {
                printf("  .");
            }
            sock.send_all(http_cmd, sizeof(http_cmd));
        }
        

        int n = sock.receive_all(buffer, BUFFER_SIZE);
            
        if(n < 0)
            break;
        else
        {
            for(int i=0; i<n; i++) 
            printf("%c", buffer[i]);
        }
            
        char *date;
        char *weather;
        char *city;
        char *temper;
        
        char cur_date[17] = {0};
        char weather_con[15] = {0};
        char city_name[10] = {0};
        char temper_data[3] = {0};
     
        int temp;
        int num100, num10, num1;
        
        date = strstr(buffer, "Date");
        for(int x=0;x<17;x++){
            cur_date[x] = date[x+6];
        }
         
        weather = strstr(buffer, "main");
        for(int i=0; i<15;i++){
            weather_con[i] = weather[i+7];
            if(weather_con[i] == 34){
                weather_con[i] = 0;
                break;
            }
        }
        
        city = strstr(buffer, "name");
        for(int j=0; j<10;j++){
            city_name[j] = city[j+7];
            if(city_name[j] == 34){
                city_name[j] = 0;
                break;
            }
        }

        temper = strstr(buffer, "temp");
        for(int k=0; k<3;k++){
            temper_data[k] = temper[k+6];
        }
           
        num100 = temper_data[0] - 48;
        num10 = temper_data[1] - 48;
        num1 = temper_data[2] - 48;
        
        temp = (num100*100 + num10*10 + num1) - 273;
        
       /* 
        *    printf  
        */
        printf("\r\n\r\n");
        printf("---------  Weather Station  --------\r\n");
        printf("-- DATE        :  %s\r\n",  cur_date);
        printf("-- CITY NAME   :  %s\r\n",  city_name);
        printf("-- WEATHER     :  %s\r\n",  weather_con);
        printf("-- TEMPURATURE :  %d\r\n",  temp);
        printf("------------------------------------\r\n");
        
        sock.close();
        
        eth.disconnect();
        
        wait(60.0);

    }
    
}