/* Example showing how to hook up to different GPS modules (GlobalSat EM406a and Adafruit Ultimate GPSv3)
*  to emulated serial ports at different speeds */
#include "mbed.h"
#include "GPS.h"


#ifdef TARGET_WIZwiki_W7500
    GPS gpsAda(D1, D0, 9600);
#else
    GPS gpsAda(P0_12, P0_15, 9600);
    GPS gpsSpark(P0_4, P0_0, 4800);
#endif

/* Private define ------------------------------------------------------------*/
#define Do3  131 //C octave3
#define Do3s 139 //C#
#define Re3  147 //D
#define Re3s 156//D#
#define Mi3  165 //E
#define Fa3  175 //F
#define Fa3s 185 //F#
#define So3  196 //G
#define So3s 208 //G#
#define La3  220 //A
#define La3s 233 //A#
#define Ti3  247 //B
#define Do4  262 //C octave4
#define Do4s 277 //C#
#define Re4  294 //D
#define Re4s 311//D#
#define Mi4  330 //E
#define Fa4  349 //F
#define Fa4s 370 //F#
#define So4  392 //G
#define So4s 415 //G#
#define La4  440 //A
#define La4s 466 //A#
#define Ti4  494 //B
#define Do5  523 //C octave5
#define Do5s 554 //C#
#define Re5  587 //D
#define Re5s 622//D#
#define Mi5  659 //E
#define Fa5  699 //F
#define Fa5s 740 //F#
#define So5  784 //G
#define So5s 831 //G#
#define La5  880 //A
#define La5s 932 //A#
#define Ti5  988 //B

/* Private variables ---------------------------------------------------------*/

Serial pc(USBTX, USBRX);

InterruptIn mysw(D7);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

PwmOut Buzzer(D5);

float C_3 = 1000000/Do3,
       Cs_3 = 1000000/Do3s,
       D_3 = 1000000/Re3,
       Ds_3 = 1000000/Re3s,
       E_3 = 1000000/Mi3,
       F_3 = 1000000/Fa3,
       Fs_3 = 1000000/Fa3s,
       G_3 = 1000000/So3,
       Gs_3 = 1000000/So3s,
       A_3 = 1000000/La3,
       As_3 = 1000000/La3s,
       B_3 = 1000000/Ti3,
       C_4 = 1000000/Do4,
       Cs_4 = 1000000/Do4s,
       D_4 = 1000000/Re4,
       Ds_4 = 1000000/Re4s,
       E_4 = 1000000/Mi4,
       F_4 = 1000000/Fa4,
       Fs_4 = 1000000/Fa4s,
       G_4 = 1000000/So4,
       Gs_4 = 1000000/So4s,
       A_4 = 1000000/La4,
       As_4 = 1000000/La4s,
       B_4 = 1000000/Ti4,
       C_5 = 1000000/Do5,
       Cs_5 = 1000000/Do5s,
       D_5 = 1000000/Re5,
       Ds_5 = 1000000/Re5s,
       E_5 = 1000000/Mi5,
       F_5 = 1000000/Fa5,
       Fs_5 = 1000000/Fa5s,
       G_5 = 1000000/So5,
       Gs_5 = 1000000/So5s,
       A_5 = 1000000/La5,
       As_5 = 1000000/La5s,
       B_5 = 1000000/Ti5;
       
       int tones[] = {G_3, D_3, G_3, D_3, G_3, D_3, 0};
       int tones_num = 8;
       
/* Private function prototypes -----------------------------------------------*/
void Tune(PwmOut name, int period);
void Auto_tunes(PwmOut name, int period);
void Stop_tunes(PwmOut name);

void exin(){
    
    int i;      
    char ch[] = {"Alert!"};
    
#ifndef TARGET_WIZwiki_W7500      
       if(gpsSpark.sample()) {
          pc.printf("set %s\t%f\t%f\t%f\t%f\t%f\n\r", ch1, gpsSpark.longitude, gpsSpark.latitude, gpsSpark.alt, gpsSpark.geoid, gpsSpark.time);
       }
#endif  
       if(gpsAda.sample()) {
          pc.printf("GPS %s \r\n longitude:%f \r\n latitude : %f \r\n",  ch, gpsAda.longitude, gpsAda.latitude);
          pc.printf(" current time : %.0f\r\n",gpsAda.time-30000);
          pc.printf("\r\n\r\n");
        }
        myled2 = !myled2;
        
    for(i=0; i<tones_num; i++)
    {
        Auto_tunes(Buzzer, tones[i]); // Auto performance
        Stop_tunes(Buzzer);
    }

}
 
int main() {
    
    pc.printf("Run now...\r\n");
    
    mysw.rise(&exin);    // attach the address of the exin function to the rising edge
    
    while(1) {           // wait around, interrupts will interrupt this!
        myled1 = !myled1;
        wait(1.0);
    } 
}

/**
   * @brief     Auto tunes Function
   */
void Auto_tunes(PwmOut name, int period)
{
    name.period_us(period);
    name.write(0.50f); // 50% duty cycle
    wait_ms(250); // 1/4 beat
}

void Stop_tunes(PwmOut name)
{
    name.period_us(0);
}
