
#include <stdio.h>
#include "mbed.h"
#include "WizFi250Interface.h"

#define SERVER_ADDRESS "192.168.100.1"
#define SERVER_PORT    5000

#define CLIENT_PORT    3000

#define SECURE WizFi250::SEC_AUTO
#define SSID "WizFi250_AP_Test"
#define PASS "1234567890"

#if defined(TARGET_WIZwiki_W7500)
    WizFi250Interface wizfi250(D1,D0,D7,D8,PA_12,NC,115200);
    Serial pc(USBTX, USBRX);
#endif

AnalogIn xAxis(A0);
AnalogIn yAxis(A1);

DigitalIn Fanon(D4);
DigitalIn Fanoff(D3);

DigitalOut red(LED1);
DigitalOut green(LED2);

void UDPClient();


int main()
{
    pc.baud(115200);
 
    printf("WizFi250 Hello World demo. \r\n");
    wizfi250.init();
    //wizfi250.setAddress("192.168.100.10","255.255.255.0","192.168.100.1");
    if ( wizfi250.connect(SECURE, SSID, PASS))      return -1;
    printf("IP Address is %s\r\n", wizfi250.getIPAddress());
    
    wait(1.0);
    
    UDPClient();
    
    wizfi250.disconnect();
}


void UDPClient()
{
    
    UDPSocket client;
    printf("Socket opened\r\n");
    
    client.set_blocking(false);
    client.bind(CLIENT_PORT);

    Endpoint server;
    
    server.set_address(SERVER_ADDRESS, SERVER_PORT);

    /* ready sign */
    green = 0;
    wait(0.3);
    green = 1;
    wait(0.3);
    green = 0;
    wait(0.3);
    green = 1;
    wait(0.3);
    green = 0;

    while(true)
    {
        int x,y;    
    
        char *cmd1 = "left";
        char *cmd2 = "right";
        char *cmd3 = "up";
        char *cmd4 = "down";
        char *cmd5 = "init";
        char *cmd6 = "fanon";
        char *cmd7 = "fanoff";
    
        char send_data[10];
        
        x = xAxis.read() * 1000; // float (0->1) to int (0-1000)
        y = yAxis.read() * 1000;
          
        if ( (x < 10) || ((y > 350)&&(y < 420)) )       
        {
            sprintf(send_data, "%s", cmd1);
            printf("left\r\n");
        }
        else if ( (x > 990) || ((y > 520)&&(y < 620)) )
        {
            sprintf(send_data, "%s", cmd2);
            printf("right\r\n");
        }
        else if ( ((x > 480)&&(x < 570)) || (y > 990) ) 
        {
            sprintf(send_data, "%s", cmd3);
            printf("up\r\n");
        }
        else if ( ((x > 350)&&(x < 420)) || (y < 10) )  
        {
            sprintf(send_data, "%s", cmd4);
            printf("down\r\n");
        }
        else if (Fanon == 1)
        {
            sprintf(send_data, "%s", cmd6);
            printf("fan on\r\n");
        }
        else if (Fanoff == 1)
        {
            sprintf(send_data, "%s", cmd7);
            printf("fan off\r\n");
        }
        else
        {
            sprintf(send_data, "%s", cmd5);
            printf("init\r\n");
        }

         
        client.sendTo(server, send_data, sizeof(send_data));
        
        char in_buffer[256];
        int n = client.receiveFrom(server, in_buffer, sizeof(in_buffer));
        in_buffer[n] = '\0';

        if( n > 0 )
            printf("%s\r\n", in_buffer);
            
        wait(1.0);
    };

    client.close();
}
