#include "mbed.h"
#include "EthernetInterface.h"

DigitalOut myled1(LED1,1);
DigitalOut myled2(LED2,1);


// Intitialize the Ethernet Client Library
EthernetInterface eth;    


int main() {
   
    printf("-- Welcome WIZwiki-W7500 Platform -- \r\n");
    
    myled1 = 0;
    
    // Enter a MAC Address for your Platform
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x03, 0x04, 0x02}; 
    
    // Initializing MAX Address
    eth.init(mac_addr);
    
    do{
        printf("   Link - Wait... \r\n");
        wait(1);
    }while(!eth.ethernet_link());
    printf("-- Ethetnet PHY Link - Done -- \r\n");
    
    if (eth.connect() < 0 )
        printf("-- EThernet Connect - Fail -- \r\n");
    else
    {
        printf("-- Assigned Network Information -- \r\n");
        printf("   IP   : %s\r\n\r\n", eth.getIPAddress()); 
        printf("   MASK : %s\r\n\r\n", eth.getNetworkMask());
        printf("   GW   : %s\r\n\r\n", eth.getGateway());
    }
    
    myled1 = 1;
    
    while(1) {
        myled2 = 1;
        wait(0.5);
        myled2 = 0;
        wait(0.5);
    }
    
}