#include "mbed.h"
#include "PinDetect.h"
#include "SSD1306.h"


DigitalOut Yellow(D13);
DigitalOut LED[5] = {D8,D9,D10,D11,D12};
PinDetect  BUTTON[5] = {D3,D4,D5,D6,D7};

#define level0 0.4
#define level1 0.15

char temp_line[5] = {0};
char line[5] = {0};
char answer[5] = {0};
int user_score = 0;
int level = 0;
int life = 0;
int score_up = 0;

uint8_t offset1 = 50;
uint8_t offset2 = 75;
char buf_0[8] = "0";
char buf_1[8] = "1";
char buf_2[8] = "2";
char buf_3[8] = "3";

void LED_BLINK();

void START();
void INIT();
void SETLINE();
void SHOWLINE();

void KEY0PRESSED();
void KEY1PRESSED();
void KEY2PRESSED();
void KEY3PRESSED();
void KEY4PRESSED();
void PRESSBUTTON();

int COMPARE();

void SCORE();

void CLOSE();


int main()
{

    START();
        
    init();
    cls();
    wait(1.0);
    OLED_DrawBMP(0,0,128,8,(unsigned char *)ready);
    wait(2.0);
    OLED_DrawBMP(0,0,128,8,(unsigned char *)go);
    wait(1.5);
    cls();
    OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_full);
    LED_P23x32Str(offset2,3,buf_0);

    wait(0.5);
    
    printf("start\r\n");
    
    while(1){      
        if(user_score == 30 && level == 1)  break;
        
        INIT();
        SETLINE();
        PRESSBUTTON();
        
        wait(1.0);  // wait for answer time      
        
        int ret = COMPARE();
        
        if(ret < 0){
            printf("bubu\r\n");
            life--;
            if(life == 2){
                score_up = 0;
                SCORE();
            }else if(life == 1){
                score_up = 0;
                SCORE();
            }else if(life == 0){
                if(level == 0){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_empty);
                    wait(0.1);
                }else if(level == 1){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_empty);
                    wait(0.1);
                }else{
                    printf("life error\r\n");
                }
                
                break;
                
            }else{
                printf("score display error\r\n");
                score_up = 0;
                SCORE();
            }
        }else{
            printf("correct\r\n");
            score_up = 1;
            SCORE();
        }
                
        wait(2.0);
    }
    
    CLOSE();
    
    printf("end\r\n");

    
}



void LED_BLINK( void ) {
    for(int i = 0; i < 5; i++)  LED[i] = 1;     Yellow = 0;     wait(0.5);
    for(int i = 0; i < 5; i++)  LED[i] = 0;     Yellow = 1;     wait(0.5);
    for(int i = 0; i < 5; i++)  LED[i] = 1;     Yellow = 0;     wait(0.5);
    for(int i = 0; i < 5; i++)  LED[i] = 0;     Yellow = 1;     wait(0.5);
    for(int i = 0; i < 5; i++)  LED[i] = 1;     Yellow = 0;     wait(0.5);
    for(int i = 0; i < 5; i++)  LED[i] = 0;     Yellow = 1;
}

// callbacks follow.
void START( void ){
    user_score = 0;
    life = 3;
    score_up = 0;
    level = 0;
    
    LED_BLINK();
    
    printf("start\r\n");        // oled diaplay part
}

// initialize
void INIT( void ) {
    for(int i = 0; i < 5; i++){
        line[i] = 0;
        answer[i] = 0;
    }
}

// set led random value and display
void SETLINE( void ) {       
    for(int j = 0; j < 2; j++){ 
    
        for(int i = 0; i < 5; i++){
            temp_line[i] = rand() % 2;
            line[i] = line[i] + temp_line[i];
            printf("line[%d] = %d\r\n",i,line[i]);
        }
        
        int temp = 0;      
        for(int i = 0; i < 5; i++){
            temp = temp + temp_line[i];
        }
              
        if(temp == 0){   
            for(int i = 0; i < 5; i++){
                temp_line[i] = 1;
            }
        }else{ 
            for(int i = 0; i < 5; i++){
                temp_line[i] = temp_line[i];
            }
        } 
             
        for(int i = 0; i < 5; i++) {
            if(temp_line[i] > 0){
                LED[i] = 1;
                temp_line[i]--;
            }else {
                LED[i] = 0;
            }
            
            if(level == 0)      wait(level0);
            else if(level == 1) wait(level1);
            else                wait(level0);
            
            LED[i] = 0;
            wait(0.02);
        }
    } 
}


// button 
void KEY0PRESSED( void ) {
    answer[0]++;
    printf("answer[0] = %d\r\n",answer[0]); 
}

void KEY1PRESSED( void ) {
    answer[1]++;
    printf("answer[1] = %d\r\n",answer[1]);
}

void KEY2PRESSED( void ) {
    answer[2]++;
    printf("answer[2] = %d\r\n",answer[2]);
}

void KEY3PRESSED( void ) {
    answer[3]++;
    printf("answer[3] = %d\r\n",answer[3]);
}

void KEY4PRESSED( void ) {
    answer[4]++;
    printf("answer[4] = %d\r\n",answer[4]);
}


// interrupt
void PRESSBUTTON( void ) {
    BUTTON[0].attach_asserted(&KEY0PRESSED);
    BUTTON[1].attach_asserted(&KEY1PRESSED);
    BUTTON[2].attach_asserted(&KEY2PRESSED);
    BUTTON[3].attach_asserted(&KEY3PRESSED);
    BUTTON[4].attach_asserted(&KEY4PRESSED);
    
    for(int i = 0; i < 5; i++) {
        BUTTON[i].mode(PullDown);
        BUTTON[i].setSampleFrequency(); // Defaults to 20ms.
    }   
    wait(5.0);
}


// compare user input and random value
int COMPARE() {
    for(int i = 0; i < 5; i++) {
        printf("answer[%d]=%d\r\n",i,answer[i]);
        if(answer[i] != line[i]){
            answer[i] = 0;
            return -1;
        }else{
            answer[i] = 0;
        }
    }    
    return 0;
}

// score
void SCORE() {

    wait(0.5);
    if(level == 0){
            if(user_score == 0){
                if(score_up == 1){
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;
                    user_score = user_score + 10;
                    printf("score : %d\r\n",user_score);
                    if(life == 3){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_full);
                        LED_P23x32Str(offset1,3,buf_1);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 2){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_two);
                        LED_P23x32Str(offset1,3,buf_1);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 1){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_one);
                        LED_P23x32Str(offset1,3,buf_1);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else{
                        printf("level menu error\r\n");
                    }
                    
                }else{
                    user_score = user_score;
                    printf("score : %d\r\n",user_score);
                    if(life == 3){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_full);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 2){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_two);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 1){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_one);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else{
                        printf("level menu error\r\n");
                    }
                }
                wait(0.5);
            }
            else if(user_score == 10){
                if(score_up == 1){
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;
                    user_score = user_score + 10;
                    printf("score : %d\r\n",user_score);
                    if(life == 3){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_full);
                        LED_P23x32Str(offset1,3,buf_2);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 2){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_two);
                        LED_P23x32Str(offset1,3,buf_2);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 1){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_one);
                        LED_P23x32Str(offset1,3,buf_2);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else{
                        printf("level menu error\r\n");
                    }
                }else{
                    user_score = user_score;
                    printf("score : %d\r\n",user_score);
                    if(life == 3){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_full);
                        LED_P23x32Str(offset1,3,buf_1);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 2){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_two);
                        LED_P23x32Str(offset1,3,buf_1);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 1){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_one);
                        LED_P23x32Str(offset1,3,buf_1);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else{
                        printf("level menu error\r\n");
                    }
                }
                wait(0.5);
            }
            else if(user_score == 20){
                if(score_up == 1){
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;
                    user_score = user_score + 10;
                    printf("score : %d\r\n",user_score);
                    if(life == 3){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_full);
                        LED_P23x32Str(offset1,3,buf_3);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 2){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_two);
                        LED_P23x32Str(offset1,3,buf_3);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 1){
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_one);
                        LED_P23x32Str(offset1,3,buf_3);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else{
                        printf("level menu error\r\n");
                    }
                    wait(0.5);
                    cls();
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)levelup);
                    user_score = 0;
                    level = 1;
                    wait(0.5);
                    LED_BLINK();
                    cls();
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_full);
                    LED_P23x32Str(offset2,3,buf_0);
                }else{
                    user_score = user_score;
                    printf("score : %d\r\n",user_score);
                    if(life == 3){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_full);
                        LED_P23x32Str(offset1,3,buf_2);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 2){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_two);
                        LED_P23x32Str(offset1,3,buf_2);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else if(life == 1){
                        Yellow = 0;  wait(0.7);
                        Yellow = 1;  wait(0.2);
                        OLED_DrawBMP(0,0,128,8,(unsigned char *)level0_one);
                        LED_P23x32Str(offset1,3,buf_2);
                        LED_P23x32Str(offset2,3,buf_0);
                    }else{
                        printf("level menu error\r\n");
                    }
                }
                wait(0.5);
            }else {
                user_score = user_score;
                printf("score error\r\n");
                
                wait(0.5);
            }
            
    }else if(level == 1){
        if(user_score == 0){
            if(score_up == 1){
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;
                user_score = user_score + 10;
                printf("score : %d\r\n",user_score);
                if(life == 3){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_full);
                    LED_P23x32Str(offset1,3,buf_1);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 2){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_two);
                    LED_P23x32Str(offset1,3,buf_1);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 1){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_one);
                    LED_P23x32Str(offset1,3,buf_1);
                    LED_P23x32Str(offset2,3,buf_0);
                }else{
                    printf("level menu error\r\n");
                }
                
            }else{
                user_score = user_score;
                printf("score : %d\r\n",user_score);
                if(life == 3){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_full);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 2){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_two);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 1){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_one);
                    LED_P23x32Str(offset2,3,buf_0);
                }else{
                    printf("level menu error\r\n");
                }
            }
            wait(0.5);
        }
        else if(user_score == 10){
            if(score_up == 1){
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;
                user_score = user_score + 10;
                printf("score : %d\r\n",user_score);
                if(life == 3){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_full);
                    LED_P23x32Str(offset1,3,buf_2);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 2){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_two);
                    LED_P23x32Str(offset1,3,buf_2);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 1){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_one);
                    LED_P23x32Str(offset1,3,buf_2);
                    LED_P23x32Str(offset2,3,buf_0);
                }else{
                    printf("level menu error\r\n");
                }
            }else{
                user_score = user_score;
                printf("score : %d\r\n",user_score);
                if(life == 3){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_full);
                    LED_P23x32Str(offset1,3,buf_1);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 2){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_two);
                    LED_P23x32Str(offset1,3,buf_1);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 1){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_one);
                    LED_P23x32Str(offset1,3,buf_1);
                    LED_P23x32Str(offset2,3,buf_0);
                }else{
                    printf("level menu error\r\n");
                }
            }
            wait(0.5);
        }
        else if(user_score == 20){
            if(score_up == 1){
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;  wait(0.2);
                    Yellow = 0;  wait(0.2);
                    Yellow = 1;
                user_score = user_score + 10;
                printf("score : %d\r\n",user_score);
                if(life == 3){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_full);
                    LED_P23x32Str(offset1,3,buf_3);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 2){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_two);
                    LED_P23x32Str(offset1,3,buf_3);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 1){
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_one);
                    LED_P23x32Str(offset1,3,buf_3);
                    LED_P23x32Str(offset2,3,buf_0);
                }else{
                    printf("level menu error\r\n");
                }
                wait(1.0);
                
            }else{
                user_score = user_score;
                printf("score : %d\r\n",user_score);
                if(life == 3){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_full);
                    LED_P23x32Str(offset1,3,buf_2);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 2){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_two);
                    LED_P23x32Str(offset1,3,buf_2);
                    LED_P23x32Str(offset2,3,buf_0);
                }else if(life == 1){
                    Yellow = 0;  wait(0.7);
                    Yellow = 1;  wait(0.2);
                    OLED_DrawBMP(0,0,128,8,(unsigned char *)level1_one);
                    LED_P23x32Str(offset1,3,buf_2);
                    LED_P23x32Str(offset2,3,buf_0);
                }else{
                    printf("level menu error\r\n");
                }
            }
            wait(0.5);
        }else {
            user_score = user_score;
            printf("score error\r\n");
            
            wait(0.5);
        }
    }
} 

void CLOSE( void ) {
    OLED_DrawBMP(0,0,128,8,(unsigned char *)end);
}


