#ifndef NL_LOGGER_CORE
#define NL_LOGGER_CORE
#include "mbed.h"
#include "record_ring.h"

#define nl_name_length 100
/**
Data collection system that uses the ninelocks ring buffer and record ring buffer library as part of a data collection system
This is based on very old early 1990s code from another project. Its been tweaked to allow use of the mbed

This code expect you to derive your own data collection function inheritaed from this class and implement your own functions ofr


*/

class NineLoggerCore {
public:
    NineLoggerCore();
    NineLoggerCore(Serial * pc);
    void setfilename(char* filename);
    
    //these are general 
    int get_overrun_count();
    int get_write_error_count();
    int get_max_fill(); //see how much of ring buffer got used at worse
    // You should implement these in your own class, ie override them.
    //I may eventuall y make these callbacks instead.
    
    void do_journal(long seconds, char entryType);
    bool flush_buffered_journal_events();
    
    
  //  virtual bool write_error_log() { return true; }
  //  void flash(int n);
 
private:  
   
protected:  
 char journallog_filename[nl_name_length]; //name of log file
  Serial *  _pc;          //if we pass in a serial port then we write out debug messages
                          // and if we dont, then guess what, we dont!  
  JRecordRing log_buffer; //where the timed samples get sent to a ring buffer of records
  int overrun_count;      //counts how many times we ran out of storage room
                          //which implies we dont have big enough buffer  :-)
  int write_error_count;  
  int max_buffer_use;     //how much of buffer was used at worse.                        

};

#endif