
 
 /*
 jont@ninelocks.com
 
 Code to interface to LCD dot matric display connected via the I2C Bus
 
 Some of this dates back to an H8 project from the 90's
 
 Isnt C a truly wonderous thing :-)
 
 */
#include "mbed.h"
#include "jtlcd.h"
#include "stdarg.h"
#include "stdio.h"
#define LCDCONTROL 0x00
#define LCDDATA 0x40

#define LCDBOTTOMSTART  0x40    /* start address of bottom line */
#define LCDTOPSTART 0x00    /* start address of top line    */

I2C i2c(p28, p27);        // sda, scl


/*==============================================================*/
/* LcdGetAddress                        */
/*==============================================================*/
/*
int LcdGetAddress(void)
{
int it;    //   current address position   
it =read_E_port( LCDCONTROL);
return(it);

}
*/
/*==============================================================*/
/* LcdSetAddress                        */
/*==============================================================*/

void LcdSetAddress(int address)
{
  //  LcdReady();
    address |= 0x80;    /* write cg/dd ram address */   
    write_E_port(LCDCONTROL, address);
}


/*==============================================================*/
/* LcdClear                         */
/*==============================================================*/
void LcdClear(void)
{
   // LcdReady();
    write_E_port(LCDCONTROL, 0x01);
}    
/*==============================================================*/
/* LcdHomeTop                           */
/*==============================================================*/
void LcdHomeTop(void)
{
   // LcdReady();
    write_E_port(LCDCONTROL, 0x02);
}
/*==============================================================*/
/* LcdHomeBottom                        */
/*==============================================================*/
void LcdHomeBottom(void)
{
    //LcdReady();
    write_E_port(LCDCONTROL, 0xc0);
}

/*==============================================================*/
/* LcdCursorLeft                        */
/*==============================================================*/
void LcdCursorLeft(void)
{
    //LcdReady();
    write_E_port(LCDCONTROL, 0x10);
}       

/*==============================================================*/
/* LcdCursorRight                       */
/*==============================================================*/
void LcdCursorRight(void)
{
    //LcdReady();
    write_E_port(LCDCONTROL, 0x14);
}

/*==============================================================*/
/* LcdSpace                         */
/*==============================================================*/
void LcdSpace(void)
{
   // LcdReady();
    write_E_port(LCDDATA, 0x20);
}

/*==============================================================*/
/* LcdNSpace                            */
/*==============================================================*/
void LcdNSpace(int number)
 
{
int count;
    for (count = 0; count < number; count++)
    {
        LcdSpace();
    }
}

/*==============================================================*/
/* LcdCursorNRight                      */
/*==============================================================*/
void LcdCursorNRight(int number)
{
    for (int n=0; n< number; n++)
    {
    LcdCursorRight();
    }   
}

/*==============================================================*/
/* LcdNLeft                         */
/*==============================================================*/
void LcdCursorNLeft(int number)

{
for (int n=0; n< number; n++)
    {
    LcdCursorLeft();
    }   
}


/*==============================================================*/
/* LcdClearTop                          */
/*==============================================================*/
void LcdClearTop(void)
{
    LcdHomeTop();
    LcdNSpace(0x27);
    LcdHomeTop();

}

/*==============================================================*/
/* LcdClearBottom                       */
/*==============================================================*/
void LcdClearBottom(void)
{
    LcdHomeBottom();
    LcdNSpace(0x27);
    LcdHomeBottom();

}

/*==============================================================*/
/* LcdPositionBottom                        */
/*==============================================================*/
void LcdPositionBottom(int pos)

{
    LcdSetAddress(LCDBOTTOMSTART + pos);

}

/*==============================================================*/
/* LcdPositionTop                       */
/*==============================================================*/
void LcdPositionTop(int pos)
 
{
    LcdSetAddress(LCDTOPSTART + pos);
}


/*==============================================================*/
/* LcdCursorFlash                       */
/*==============================================================*/
void LcdCursorFlash(void)
{
    //LcdReady();
    write_E_port(LCDCONTROL, 0x0d);
}       

/*==============================================================*/
/* LcdCursorOff                         */
/*==============================================================*/
void LcdCursorOff(void)
{
   // LcdReady();
    write_E_port(LCDCONTROL, 0x0c);
}       


/*==============================================================*/
/* LcdCursorNorm                        */
/*==============================================================*/
void LcdCursorNorm(void)
{
   // LcdReady();
    write_E_port(LCDCONTROL, 0x0e);
}       





/*

void read_E_port(unsigned char command)
{
        i2c.start();
        i2c.write(Slave);
        i2c.write(command);
        i2c.stop();
         wait(0.2);
}
*/

void write_E_port(unsigned char command,unsigned char data)
{
 i2c.start();
        i2c.write(Slave);
        i2c.write(command);
        i2c.write(data);
        i2c.stop();
        wait(0.01);
}

void LcdInit()
{

        i2c.start();
        i2c.write(Slave);
        i2c.write(0x00);
        i2c.write(0x38);
        wait(0.01);  
        i2c.write(0x39); //i assume now we juyst need data?  
        wait(0.01);
        i2c.write(0x14);
        i2c.write(0x74);
        i2c.write(0x54);
        i2c.write(0x6f);
        i2c.write(0x0c); 
        i2c.write(0x01);     
        i2c.write(0x06);     
        wait(0.01);
        i2c.stop();
        

}
/*
void lcdclear()
{
        i2c.start();
        i2c.write(Slave);
        i2c.write(0x00);
        i2c.write(0x01);
        i2c.stop();
         wait(0.2);
}
*/
void test()
{

        i2c.start();
        i2c.write(Slave);
        i2c.stop();
        wait(0.2);
}


void LcdWriteText(char *text) 
{ 
 int n;//,d; 
 //d=0x00; 
 int length = strlen(text);
        i2c.start();
 i2c.write(Slave); //Slave=0x78 
 i2c.write(LCDDATA);//Datasend=0x40 
 for(n=0;n<length;n++){ 
  i2c.write(*text); 
  ++text; 
  } 
 i2c.stop(); 
} 

/*==============================================================*/
/* Writes to LCD and fills rest of line with space                      */
/*==============================================================*/
void LcdWriteTextAndFill(char *text, int numb) 
{ 
 
 int length = strlen(text);
 int diff = numb -length;
    LcdWriteText(text);
    if (diff >0)
    {
        for (int n=0; n <= diff; n++)
            LcdWriteText(" ");
    
    }
} 

/*==============================================================*/
/* Writes to LCD and fills rest of line with space based on lcd maxlength                     */
/*==============================================================*/
void LcdWriteTextLine(char *text) 
{ 
 
 int length = strlen(text);
 int diff = LCD_LINE_SIZE -length;
    LcdWriteText(text);
    if (diff >0)
    {
        for (int n=0; n <= diff; n++)
            LcdWriteText(" ");
    
    }
} 
/*==============================================================*/
/* attemp at lcdlcdprintf                       */
/*==============================================================*/

static void lcdputchar(char c, void *ptr)
{
    //LcdReady();         /* wait for lcd ready */
    write_E_port(LCDDATA, c);   /* send data to lcd */
}
 /*
int lcdprintf(const char *format, ...)
{
    va_list ap;
    int nr_of_chars;
    va_start (ap, format);  //variable arg begin    
    nr_of_chars = _formatted_write (format, lcdputchar, (void *) 0, ap);
    va_end(ap);         //variable arg end   
    return(nr_of_chars);
} */
   