#include "mbed.h"
#include "Counter.h"

/*=====================================================================================*/
// Counter object, which also setups up irq
/*=====================================================================================*/

//from http://mbed.org/handbook/InterruptIn, modified to add debouncing

Counter::Counter(PinName pin, void (*function)(void)) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.fall(this, &Counter::increment); // attach increment function of this counter instance
        jim.attach(function);
        t.start();  //  timer start
    }

void Counter::increment() {
    if ( t.read_ms() > DEBOUNCING_INTERVAL ) {
        _count++;
        time_t seconds = time(NULL);
        // RingWriteToBuffer(seconds);

        jim.call();

    }
    t.reset();  //  timer reset
}

int Counter::read() {
    return _count;
}

int Counter::set(int val) {
    int was = _count;
    _count = val;
    return was;
}

void Counter::reset() {
        _count = 0;
    }
