#ifndef COUNTER_
#define COUNTER_

#define DEBOUNCING_INTERVAL  200    //  Debouncing interval (in mili-seconds)
/*=====================================================================================*/
// Counter object, which also setups up irq
/*=====================================================================================*/

//from http://mbed.org/handbook/InterruptIn, modified to add debouncing
class Counter
{
public:
    Counter(PinName pin, void (*function)(void));

void increment();

int read();

int set(int val);

void reset();

private:
    InterruptIn _interrupt;
    volatile int _count;
    Timer             t;               //  To manage debounce by menchanical switch
protected:
    //the callback
    FunctionPointer jim;
};



#endif
