/* Copyright (c) <year> <copyright holders>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/*
sio handler august 96
*/
//(c)jont@ninelocks.com 1992-2015
#include "string.h"
#include <stdio.h>
#include <ctype.h>

#include "mbed.h" //fiddle

#define XON     0x11
#define XOFF    0x13


//why do we end up defineing true and false

#define combuffsize  32               
void sioRXHandler(void);
//horrible as this is platform depdndent but for now
Serial pc(USBTX, USBRX); // tx, rx


int commandWaiting;    /* flag to indicate if data in buffer */
char comBuff[combuffsize];    /* space for commands yeh its small make bigger if you need to */
int comBuffIndex;    /* buffer index       */
unsigned char JPORTOK0;

void serialInit(void)
{
    JPORTOK0 = 0;
    pc.attach(&sioRXHandler);
   //  pc.printf("Hello World!");

}

/*======================================================================*/
/* Get a character into our buffer                */
/*======================================================================*/
/* read single character into command buffer */
void sioGetSingle(void)
{



//char theChar;
char theChar = 0x00; //used to be a char...
//h8    theChar = SIO_RDR;        /* get received character */
theChar = pc.getc();
pc.putc(theChar);
 
    /* if an Xoff was received from
    remote term telling us to stop...
    in which case if anything other than an xon is receievd
    we'll get caught as cant send due to xoff and cant get an irq
    as were already in one */

    switch(theChar)
        {
        case (XOFF):
            JPORTOK0 = 0xff; ;break; /* busy     */
        case (XON):
            JPORTOK0 = 0x00; ;break; /* not busy */
        case ('?'):        
           comBuffIndex = 0; comBuff[0] ='\0';
        //   printf("\n\r>?"); break; /* start of enq com */    
        default:        break;    
    }

    if (theChar != XON && theChar != XOFF && theChar != '?')
    {
        if (comBuffIndex >= combuffsize - 1)
        {
            comBuffIndex = combuffsize - 1;
        }

/* jt need to force upper case ?? also add set functions */        
        comBuff[comBuffIndex] = toupper(theChar);
        if (theChar == 0x0d)
        {
            comBuff[comBuffIndex] = '\0';    /* null terminate it */    
        }
            comBuffIndex++;    /* inc index for next time */

    /* we use to check for 2 chhars as well */
            if (theChar == 0x0d )
        {
           commandWaiting = true; /* set flag */    
           comBuffIndex = 0;        
        }        

    }

}

///should normally be called by an irq that notices incoming characters
/*======================================================================*/
/* sioRXHandler               */
/*======================================================================*/
//used to work great for one character recived, but not with mbed, so lets see if its 
//got multi characyters before it call the irq
void sioRXHandler(void)
{

//see http://mbed.org/forum/mbed/topic/3414/?page=1#comment-17231
   while (pc.readable()){
 
     sioGetSingle();
    
    
  }
  //http://mbed.org/forum/mbed/topic/408/?page=1#comment-2221
 // pc.putc(0x00);
 
// uint32_t UART_0_RBR = LPC_UART0->RBR;  
    
}
