/* Copyright (c) <year> <copyright holders>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/*
* the monitor support functions .. this needs shell to work
* this just provides an array of commands and functions and the functions
* themselves

This is based on the ancient GB3H8 code from 1992!!!!!!!!!!!!!!!!!!!
(c)jont@ninelocks.com 1992-2012

Nasty nasty code intedned to help debug other bits of the project
If you dont like the code, fix it :-)

To add your functions you need to put them in 3 places

search for JJT1 JJT2 JJT3 in this file
*/


#include "ctype.h"
#include "shell.h"
#include "mon.h"
#include "mbed.h"


/*======================================================================*/
/* the externals                            */
/*======================================================================*/
/*
Things in the main program you want to support and need access to
could be done via a header... feel free to make it so
*/

extern DigitalOut myled3;
extern AnalogIn a2d1;
extern AnalogIn a2d2;
extern AnalogIn a2d3;
extern AnalogIn a2d4;
extern AnalogIn a2d5;
extern AnalogIn a2d6;

/*==========================================================================================*/
/*==========================================================================================*/
/* the functions for the array of commands                                                  */
/*==========================================================================================*/
//JJT1 add the declaration of your function here
/*==========================================================================================*/
void command_help(void);
void command_ledon(void);
void command_ledoff(void);
void command_a2d(void);
void command_time(void); //show rtc datetime
void command_utime(void); //setunixtime 


/*======================================================================*/
/* other supporting functions                        */
/*======================================================================*/
int convertHex(char *); /* convert a buffer to ascii decimal from hex */


/*======================================================================*/
/* typdefs                                */
/*======================================================================*/

/* an struct of string for the command and pointer to function */

/*typedef struct
    {
        char *commandp;
        void (*func_p)(void);
    } cmd_entry;
*/

/*
 JJT2 put the function in this table along with the associated command you want to use in the terminal.
*/
 const cmd_entry command_table[] =
        {
            "TIME", command_time, //show real time clock as human readable
            "HELP",command_help,  //list the available commads
            "A2D", command_a2d,  //show value of analogue to digital convertor inputs
            "UTIME", command_utime, //set the realtime clock with a unix time string
            "LEDON", command_ledon, //switch test led on
            "LEDOFF", command_ledoff, //switch test led off
            "",0,0      /* this terminates table */  
        };
  
  
/*======================================================================*/
/* globals                           */
/*======================================================================*/

char valueChange = 0;   //used to point to where argument starts in the 
                        //command buffer

 
/*======================================================================*/
/* support functions                            */
/*======================================================================*/


/*======================================================================*/
/*= convert a buffer in ascii hex to ascii decimal            */
/*======================================================================*/
/*
* if successfull returns TRUE else false
* up to caller what to do about it 
*/
int convertHex(char *buffer)
{
char *oldBuffer;
int number = 0;
int digit;
int length;
oldBuffer = buffer;    /* so we can use it later */

    length = strlen(buffer);    
    if ( length > 8 || length == 0) //was 4 jt2012
    {    
    return(false);
    }

    while (*buffer != '\0')
    {
        if (isxdigit(*buffer) == 0)
        {
            return(false);
        }
        digit = *buffer;
        digit -= 0x30;
        if (digit > 9)   /* A - F */
        {
            digit -=7;
        }

        number <<=4;    /* shift left */
        number |= digit;
    buffer++;
    }                
sprintf(oldBuffer, "%d", number);
return(true);
}


/*======================================================================*/
/* here are the command handlers                    */
/*======================================================================*/

//JJT3 heres where you add your functions
/*======================================================================*/
/* command_help                                */
/*======================================================================*/
void command_help(void)
{
/* dumps all commands but only those you can use with your
current level
*/
int i= 0;
int size;        /* no of characters op */
char column = 0;    /* which column on page */
    printf("\n\r* * * * HELP * * * *\n\r");
    do
    {

            printf("%s", command_table[i].commandp);
             size =  strlen(command_table[i].commandp);
            if ( size < 8 )
            {
            for(; size < 8; size++)
                {
            printf("%c",0x20);
                }
             }    
            column++;
            if (column >= 8)
            {
                printf("\n\r");
                 column = 0;
            }            
     
        i++;    /* display next entry */
        }
        while(strcmp( command_table[i].commandp, "") != 0);

}



/*======================================================================*/
/*command_ledon                                                     */
/*======================================================================*/
void command_ledon(void)
{
myled3 = 1;
}
/*======================================================================*/
/*command_ledon                                                     */
/*======================================================================*/
void command_ledoff(void)
{
myled3 = 0;
}

/*======================================================================*/
/*command_time                                                     */
/*======================================================================*/
void command_time(void)
{
    time_t seconds = time(NULL);
    printf("%s\n", ctime(&seconds));  

}

/*======================================================================*/
/*Show Values read from A:" convertor                                                     */
/*======================================================================*/
void command_a2d()
{
    printf("A2D Readings %.2f %.2f %.2f %.2f %.2f %.2f", a2d1.read(),a2d2.read(),a2d3.read(),a2d4.read(),a2d5.read(),a2d6.read());
}

/*======================================================================*/
/* Settime using a unixtime                                             */
/*======================================================================*/
//on your desktop you get uninxtime with date +%s
void command_utime()
{      
time_t seconds;        

seconds = atol(comBuff + valueChange);  
set_time(seconds);
printf("Setting time to %s",ctime(&seconds));  

}
