/**

Description:

This program uses a Sharp Digital Distance sensor (GP2Y0D810) attached to pin 30 and 11 
(the two headers on the right and left of the board). 


**/

#include "mbed.h"
#include "SharpDigiDist100.h"
#include "m3pi.h"

DigitalOut Left[2] = {LED1,LED2};           //Some indicator LEDs for the range finders
DigitalOut Right[2] = {LED4,LED3};

SharpDigiDist100 right(p30);                // The range finder class initialisations
SharpDigiDist100 left(p11);

m3pi m3pi;                                  // Initialise the m3pi


int main() {
    
    m3pi.locate(0,0);                       // Write the name to the screen
    m3pi.printf("Sonar");                
    
    // m3pi.get_white_levels();                // Saves the current levels of the sensors to know what is white
    
    while (1) {

// This tells it what to do when it detects something on the right-hand sensor

        switch (right.getDistance()) {      // Sets up the distance indicator LEDs for the right side
            case SharpDigiDist100::Far :
                Right[0] = true;
                Right[1] = false;
                break;
            case SharpDigiDist100::Near :
                Right[1] = true;
                Right[0] = false;
                break;
            case SharpDigiDist100::Mid :
                Right[0] = true;
                Right[1] = true;
                break;
            default:
                break;
        }

// This tells it what to do when it detects something on the left-hand sensor

        switch (left.getDistance()) {       // Sets up the distance indicator LEDs for the left side
            case SharpDigiDist100::Far :
                Left[0] = true;
                Left[1] = false;
                break;
            case SharpDigiDist100::Near :
                Left[1] = true;
                Left[0] = false;
                break;
            case SharpDigiDist100::Mid :
                Left[0] = true;
                Left[1] = true;
                break;
            default:
                break;
        }
       
    }
}
