#include "SharpDigiDist100.h"

SharpDigiDist100::SharpDigiDist100(PinName pin):intin(pin),pinin(pin)
{
timer1.reset();
intin.rise(this,&SharpDigiDist100::onInt);
intin.fall(this,&SharpDigiDist100::onInt);
timer1.start();
//onInt();
current = Far;
//last = NA;
onChangeAttached = false;
}

void SharpDigiDist100::onInt()
{
    timer1.stop();
    last = current;
    int timeFromLast = timer1.read_ms();
    if (timeFromLast < 100)
    {
        current = Far;
        timeout.attach(this,&SharpDigiDist100::onInt, 0.3);
    }
    else
    {
        if(pinin)
        {
            current = Mid;
        }
        else
        {
            current = Near;
        }
    }
    if(current != last)
    {
        if(onChangeAttached)
        {
      onChange();
      }
    }
    timer1.reset();
    timer1.start();
}

int SharpDigiDist100::getDistance()
{
    return current;
}

void SharpDigiDist100::attachOnChange(void (*ptr) (void))
{
    onChange = ptr;
    onChangeAttached = true;
}