#include "interrupt.h"
#include "InterruptIn.h"


Interrupt::Interrupt (PinName pinUp, PinName pinDown, PinName pinLeft, PinName pinRight, PinName pinEnter) 
                        : _interruptUp(pinUp),_interruptDown(pinDown), _interruptLeft(pinLeft), _interruptRight(pinRight), _interruptEnter(pinEnter)  {   
     flagUp = false;
     flagDown = false;
     flagLeft = false;
     flagRight = false;
     flagEnter = false;
     _interruptUp.rise(callback (this, &Interrupt::up_interrupt));
     _interruptDown.rise(callback (this, &Interrupt::down_interrupt));
     _interruptLeft.rise(callback (this, &Interrupt::left_interrupt));
     _interruptRight.rise(callback (this, &Interrupt::right_interrupt));
     _interruptEnter.rise(callback (this, &Interrupt::enter_interrupt));

     lastnumberIP = 101;
     currentScreen = 0;
     nextScreen = 0;
}

void Interrupt::up_interrupt () {
    //nextScreen++;
    flagUp = true;
}

void Interrupt::down_interrupt () {
    //nextScreen--;
    flagDown = true;
}

void Interrupt::left_interrupt () {        
    flagLeft = true;
}

void Interrupt::right_interrupt () {
    flagRight = true;  
}

void Interrupt::enter_interrupt () {
    flagEnter = true;

}







