#include "menu.h"
#include "tcp.h"
#include "lcd.h"
#include "platform/mbed_thread.h"

Interrupt newinterrupt(A2,A3,A4,A5,D4);
LCD newlcd;  
TCP tcp;
Menu::Menu (){
    lastnumberIP = 101;
    frequency = 98;
    length = 120;
    i = 1;
    count = 0;
}

void Menu::beginmenu () {
    if ( newinterrupt.flagRight ==  true && i < 4) {
    i++;
    newinterrupt.flagRight = false;
    }
    if ( newinterrupt.flagLeft == true && i > 1) {
    i--;
    newinterrupt.flagLeft = false;
    }
    newlcd.printstart();
    
    switch (i) {
        case 1:
        newlcd.printrectsend();
        if (newinterrupt.flagEnter == true) {
           newinterrupt.nextScreen++;
           newinterrupt.flagEnter = false;
        }
        break;
        
        case 2:
        newlcd.printrectreceive();
        if (newinterrupt.flagEnter == true) {
           newinterrupt.flagEnter = false;
           receivepacket();
        }
        break;
        
        case 3:
        newlcd.printrectstatus();
        break;         
    }
}

void Menu::receivepacket() {
    newlcd.receivepacket();
    tcp.receive();
    newlcd.receivepacketconfirmed(tcp.buffer);
}
void Menu::sendpacket() {
        newlcd.sendpacket();
        tcp.send(lastnumberIP);
        newlcd.sendpacketconfirmed();
        thread_sleep_for(3.0);
        newinterrupt.nextScreen = 0;
}

void Menu::enter() {
    if (newinterrupt.flagEnter == true) {
        newinterrupt.flagEnter = false;
        newinterrupt.nextScreen++;
        }
}

void Menu::back() {
    if (newinterrupt.flagEnter == true) {
        newinterrupt.flagEnter = false;
        newinterrupt.nextScreen--;
        }    
}

void Menu::selectIP() {
    if ( newinterrupt.flagLeft == true && lastnumberIP < 121) {
        lastnumberIP++;
        newinterrupt.flagLeft = false;
        }
    if ( newinterrupt.flagRight == true&& lastnumberIP > 101) {
        lastnumberIP--;
        newinterrupt.flagRight = false;
        }
    newlcd.printIP(lastnumberIP);
    
    if (newinterrupt.flagEnter == true) {
        newinterrupt.flagEnter = false;
        newinterrupt.nextScreen++;
    }
}

void Menu::selectfrequency () {
    if (newinterrupt.flagLeft == true && frequency < 130) {
        frequency++;
        newinterrupt.flagLeft = false;
        }
    if (newinterrupt.flagRight == true && frequency > 98) {
        frequency--;
        newinterrupt.flagRight = false;
        }

    newlcd.printfreq(frequency);
    
    if (newinterrupt.flagEnter == true) {
    newinterrupt.flagEnter = false;
    newinterrupt.nextScreen++;
    }
}
void Menu::selectlength() {
    if (newinterrupt.flagLeft == true && length < 480) {
        length = length + 20;
        newinterrupt.flagLeft = false;
        }
    if (newinterrupt.flagRight == true && length > 120) {
        length = length - 20;
        newinterrupt.flagRight = false;
        }
    newlcd.printlength(length);
    
    if (newinterrupt.flagEnter == true) {
    newinterrupt.flagEnter = false;
    newinterrupt.nextScreen++;
    }
}
void Menu::updateLCD () {

    switch (newinterrupt.currentScreen){
        case 0:
        beginmenu();
        break;
        case 1:
        selectIP();
        break;
        case 2:
        selectfrequency();
        break;
        case 3:
        selectlength();
        break;
        case 4:
        sendpacket();
        break;
    }
}

void Menu::screen () {
    if (newinterrupt.currentScreen != newinterrupt.nextScreen) {
        newinterrupt.currentScreen = newinterrupt.nextScreen;
        updateLCD();
    }
    if (newinterrupt.flagLeft || newinterrupt.flagRight || newinterrupt.flagEnter) {
        newinterrupt.currentScreen = newinterrupt.nextScreen;
        updateLCD();
    }
}

