#include "lcd.h"
#include "C12832.h"
C12832 lcd(D11, D13, D12, D7, D10);


LCD::LCD () {
    IP = 0;
    freq = 0;
    duration = 0;
    char message [32];
}

void LCD::printstart() {
    lcd.cls();
    lcd.locate(5,15);
    lcd.printf("Send");
    lcd.locate(40,15);
    lcd.printf("Receive");
    lcd.locate(85,15);
    lcd.printf("Status");
}

void LCD::printrectsend() {
    lcd.rect(3, 13, 29, 25, 1);
    lcd.rect(38, 13, 73, 25, 0);
    lcd.rect(83, 13, 115, 25, 0);
}

void LCD::printrectreceive() {
    lcd.rect(3, 13, 29, 25, 0);
    lcd.rect(38, 13, 73, 25, 1);
    lcd.rect(83, 13, 115, 25, 0);
}
void LCD::printrectstatus() {
    lcd.rect(3, 13, 29, 25, 0);
    lcd.rect(38, 13, 73, 25, 0);
    lcd.rect(83, 13, 115, 25, 1);
}

void LCD::printIP(unsigned int IP) {
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf("Choose an ip address.");
    lcd.locate(3,15);
    lcd.printf("192.168.0. %d" , IP);  

}

void LCD::sendpacket() {
    lcd.cls();
    lcd.locate(20,12);
    lcd.printf("sending packet ...");  
}

void LCD::sendpacketconfirmed() {
    lcd.cls();
    lcd.locate(20,12);
    lcd.printf("packet has been send");    
}

void LCD::receivepacket() {
    lcd.cls();
    lcd.locate(20,12);
    lcd.printf("receiving packet ...");

}
void LCD::receivepacketconfirmed(char message[32]) {
    lcd.cls();
    lcd.locate(0,12);
    lcd.printf("%s", message);    
}

void LCD::printfreq(unsigned int freq) {
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf("Choose an frequency");
    lcd.locate(3,15);
    lcd.printf("frequency: %d" , freq);

}
void LCD::printlength(unsigned int duration) {
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf("Choose an length");
    lcd.locate(3,10);
    lcd.printf("length: %d" , duration); 
}


