/* NeatGUI Library
 * Copyright (c) 2013 Neil Thiessen
 * Copyright (c) 2017 Jon Buckman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "ILI9163.h"

ILI9163::ILI9163(PinName D0, PinName D1, PinName D2, PinName D3, PinName D4, PinName D5, PinName D6, PinName D7, PinName cs, PinName dc, PinName wr, PinName rst) : Display(160, 128),  bus(D7, D6, D5, D4, D3, D2, D1, D0),
    m_CS(cs), m_DC(dc), m_WR(wr), m_RST(rst)
{
    //Set the control pins to a known state
    m_CS = 1;
    m_DC = 1;
    m_WR = 0;
    m_RST = 0;
}

bool ILI9163::open()
{
    // toggle RST low to reset
    m_RST =1;
    wait_ms(5);
    m_RST =0;
    wait_ms(20);
    m_RST =1;
    wait_ms(150);

// New Haven Displays Initialization
    writeCommand(0x01);     // Software reset
    wait_ms(5);
    writeCommand(0x11);     // Exit sleep mode
    wait_ms(100);
    writeCommand(0x26);     // Set Gamma curve
    writeData8(0x04);
    writeCommand(0xF2);     // Gamma adjustment enabled
    writeData8(0x00);
    writeCommand(0xB1);     // Frame rate control 1
    writeData8(0x0A);
    writeData8(0x14);
    writeCommand(0xC0);     // Power control 1
    writeData8(0x0A);
    writeData8(0x00);
    writeCommand(0xC1);     // Power control 2
    writeData8(0x02);
    writeCommand(0xC5);     // Vcom control 1
    writeData8(0x2F);
    writeData8(0x3E);
    writeCommand(0xC7);     // Vcom offset
    writeData8(0x40);
    writeCommand(0x2A);     // Set column address
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x7F);
    writeCommand(0x2B);     // Set page address
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x9F);
    writeCommand(0x36);     // Set address mode
    writeData8(0x48);
    writeCommand(0x29);     // Set display on
    writeCommand(0x2C);     // Write memory start

// Bodmer Initialization
/*
    writeCommand(0x01);     // Software reset
    wait_ms(5);
    writeCommand(0x11);     // Exit sleep mode
    writeCommand(0x3A);     // Set pixel format
    writeData8(0xC5);
    writeCommand(0x26);     // Set Gamma curve
    writeData8(0x04);
    writeCommand(0xF2);     // Gamma adjustment enabled
    writeData8(0x01);
    writeCommand(0xE0);     // Positive Gamma
    writeData8(0x3F);
    writeData8(0x25);
    writeData8(0x1C);
    writeData8(0x1E);
    writeData8(0x20);
    writeData8(0x12);
    writeData8(0x2A);
    writeData8(0x90);
    writeData8(0x24);
    writeData8(0x11);
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x00);
    writeCommand(0xE1);     // Negative Gamma
    writeData8(0x20);
    writeData8(0x20);
    writeData8(0x20);
    writeData8(0x20);
    writeData8(0x05);
    writeData8(0x00);
    writeData8(0x15);
    writeData8(0xA7);
    writeData8(0x3D);
    writeData8(0x18);
    writeData8(0x25);
    writeData8(0x2A);
    writeData8(0x2B);
    writeData8(0x2B);
    writeData8(0x3A);
    writeCommand(0xB1);     // Frame rate control 1
    writeData8(0x08);
    writeData8(0x08);
    writeCommand(0xB4);     // Display inversion
    writeData8(0x07);
    writeCommand(0xC0);     // Power control 1
    writeData8(0x0A);
    writeData8(0x02);
    writeCommand(0xC1);     // Power control 2
    writeData8(0x02);
    writeCommand(0xC5);     // Vcom control 1
    writeData8(0x50);
    writeData8(0x5B);
    writeCommand(0xC7);     // Vcom offset
    writeData8(0x40);
    writeCommand(0x2A);     // Set column address
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x7F);
    writeCommand(0x2B);     // Set page address
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x00);
    writeData8(0x9F);
    writeCommand(0x36);     // Set address mode
    writeData8(0x48);
    writeCommand(0x29);     // Set display on
*/
    //Return success
    return true;
}

void ILI9163::flush()
{
    //Select low col 0, hi col 0, line 0
    //writeCommand(CMD_SETLOWCOLUMN | 0x0);
    //writeCommand(CMD_SETHIGHCOLUMN | 0x0);
    //writeCommand(CMD_SETSTARTLINE | 0x0);

    //Make sure the first byte in the buffer is the control byte
    //m_Buffer[0] = CONTROL_DATA;

    //Write the buffer
    //m_I2C.write(m_Addr, m_Buffer, 1025);
}

Display::State ILI9163::state()
{
    //Return the base class's state
    return Display::state();
}

void ILI9163::state(State s)
{
    //Check what the requested state is
    if (s == Display::DISPLAY_ON) {
        //Turn the display on
        //writeCommand(CMD_DISPLAYON);
    } else if (s == Display::DISPLAY_OFF) {
        //Turn the display off
        //writeCommand(CMD_DISPLAYOFF);
    }

    //Update the base class
    Display::state(s);
}

void ILI9163::drawPixel(int x, int y, unsigned int c)
{
    //Range check the pixel
    if ((x < 0) || (x >= width()) || (y < 0) || (y >= height()))
        return;
    
    //TODO: Clean up this code!!!
    
    //Set the column
    writeCommand(0x2A);
    writeData16(x);
    writeData16(x);
    
    //Set the page
    writeCommand(0x2B);
    writeData16(y);
    writeData16(y);
    
    //Don't know what this does...
    writeCommand(0x2C);
    
    //Woohoo, send the pixel!!!
    writeData16(c);
    
    //TODO: Clean up this code!!!
}

void ILI9163::writeCommand(char command)
{
    //Pull dc low for Command
    m_DC = 0;

    //Pull cs low to select the TFT
    m_CS = 0;

    //Pull wr low to initialize for write
    m_WR = 0;

    //Set the command byte
    bus = command;

    //Write the command byte
    m_WR = 1;

    //Pull CS high to end the transfer
    m_CS = 1;
}

void ILI9163::writeData8(char data)
{
    //Pull dc low for Data
    m_DC = 1;

    //Pull cs low to select the TFT
    m_CS = 0;

    //Pull wr low to initialize for write
    m_WR = 0;

    //Set the data byte
    bus = data;

    //Write the command byte
    m_WR = 1;

    //Pull CS high to end the transfer
    m_CS = 1;
}

void ILI9163::writeData16(unsigned short data)
{
    //Pull dc low for Data
    m_DC = 1;

    //Pull cs low to select the TFT
    m_CS = 0;

    //Pull wr low to initialize for write
    m_WR = 0;

    //Write the 2 data bytes
    bus = (char)(data >> 8);

    //Write the command byte
    m_WR = 1;

    //Pull wr low to initialize for write
    m_WR = 0;

    bus = (char)data;

    //Write the command byte
    m_WR = 1;

    //Pull CS high to end the transfer
    m_CS = 1;
}
