/* Simple moving average filter
 * Copyright (c) 2019 Jon Buckman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "MAF.h"

MAF::MAF()
{}
/*
float MAF::update(float data)
{
    _k[0] = data;
    _result = _k[0]*0.1f + _k[1]*0.1f + _k[2]*0.1f + _k[3]*0.1f + _k[4]*0.1f + _k[5]*0.1f + _k[6]*0.1f + _k[7]*0.1f + _k[8]*0.1f + _k[9]*0.1f ;
    _k[9] = _k[8];
    _k[8] = _k[7];
    _k[7] = _k[6];
    _k[6] = _k[5];
    _k[5] = _k[4];
    _k[4] = _k[3];
    _k[3] = _k[2];
    _k[2] = _k[1];
    _k[1] = _k[0];
   
   return _result;
}
*/
float MAF::update(float data)
{
    _k[0] = data;
    _result = _k[0]*0.25f + _k[1]*0.25f + _k[2]*0.25f + _k[3]*0.25f ;
    _k[3] = _k[2];
    _k[2] = _k[1];
    _k[1] = _k[0];

   return _result;
}
