#include "mbed.h"
#include "rtos.h"

#include "EthernetInterface.h"
#include "NTPClient.h"


const char *newline = "\r\n";
const unsigned int connection_timeout = 6000;
const unsigned int network_ticker_period = 60000;
const unsigned int producer_ticker_period = 15000;


BusOut leds(LED1, LED2, LED3, LED4);

typedef struct {
    uint16_t count;
} tMessage;

Mail<tMessage, 64> mailbox;

EthernetInterface ethernet;
TCPSocketConnection socket;

static bool timeset = false;
NTPClient ntp;



void connection_callback()
{
    printf("%s:%d%s", __FILE__, __LINE__, newline);

    leds = (leds ^ 1);
    char data[512];
    char *p = data;

    uint16_t nmessages = 0;
    osEvent evt;
    do {
        evt = mailbox.get(0);
        if (osEventMail == evt.status) {
            tMessage *message = (tMessage *)evt.value.p;
            if (message) {
                nmessages += 1;
                p += snprintf(p, sizeof(data) - (p-data), "%d%s", message->count, newline);
                mailbox.free(message);
            }
        }
    } while (osEventMail == evt.status && (p-data) < 384);

    printf("%s:%d nmessages:%d%s", __FILE__, __LINE__, nmessages, newline);
    if (!socket.is_connected()) {
        socket.connect("10.0.1.253", 8080);
    }

    printf("%s:%d%s", __FILE__, __LINE__, newline);
    if (socket.is_connected()) {
        if (p > data) {
            printf(data);
            printf(newline);
            printf("%s:%d%s", __FILE__, __LINE__, newline);
            int nsent = socket.send_all(data, (p-data)-1);
            printf("%s:%d: nmessages:%d, length:%d, nsent:%d, %s", __FILE__, __LINE__, nmessages, (p-data)-1, nsent, newline);
        }
        socket.close();
    } else {
        printf("%s:%d: nmessages:%d, discarded_length:%d%s", __FILE__, __LINE__, nmessages, (p-data)-1, newline);
    }

    printf("%s:%d%s", __FILE__, __LINE__, newline);
}


void network_callback (const void *context)
{
    printf("%s:%d%s", __FILE__, __LINE__, newline);

    if (!ethernet.getIPAddress()) {
        printf("%s:%d%s", __FILE__, __LINE__, newline);
        ethernet.connect(connection_timeout);
        printf("%s:%d%s", __FILE__, __LINE__, newline);
    }

    if (ethernet.getIPAddress()) {
        printf("%s:%d%s", __FILE__, __LINE__, newline);
        leds = (leds ^ 2);
        if (false == timeset) {
            printf("%s:%d%s", __FILE__, __LINE__, newline);
            if (NTP_OK == ntp.setTime("0.pool.ntp.org")) {
                printf("%s:%d timeset%s", __FILE__, __LINE__, newline);
                timeset = true;
            }
            printf("%s:%d%s", __FILE__, __LINE__, newline);
        }

        connection_callback();

        ethernet.disconnect();
        printf("%s:%d%s", __FILE__, __LINE__, newline);
    }

    printf("%s:%d%s", __FILE__, __LINE__, newline);
}


void producer_ticker(const void *context)
{
    printf("%s:%d%s", __FILE__, __LINE__, newline);
    static uint16_t counter = 0;

    tMessage *message = mailbox.alloc();
    if (message) {
        leds = (leds ^ 4);
        memset(message, 0, sizeof(*message));
        message->count = ++counter;
        mailbox.put(message);
    }
    printf("%s:%d%s", __FILE__, __LINE__, newline);
}


int main()
{
    printf("%s:%d%s", __FILE__, __LINE__, newline);
    ethernet.init();
    printf("%s:%d%s", __FILE__, __LINE__, newline);

    RtosTimer producer(producer_ticker);
    RtosTimer network(network_callback);
    printf("%s:%d%s", __FILE__, __LINE__, newline);

    producer.start(producer_ticker_period);
    network.start(network_ticker_period);
    printf("%s:%d%s", __FILE__, __LINE__, newline);

    while (true) {
        Thread::wait(500);
        leds = (leds ^ 8);
    }
}
