#include "mbed.h"
#include "HX711.h"

HX711 load_cell(A0,A1);// 

AnalogIn POF_sensor_1(A5);
AnalogIn POF_sensor_2(A3);
AnalogIn POF_sensor_3(A4);
float S1,S2,S3;
float calibration_factor = 199030; //
float sample,sample_ant,delta_sample;
int averageSamples = 1;
Timer t;

Serial pc(USBTX, USBRX,115200);

int main() {

    //millisStart();                
    
    //float f = t.read();
    //uint32_t m = t.read_ms();
    
    load_cell.setScale(0);
    load_cell.tare(); //Reset the scale to 0
    
    long zero_factor = load_cell.averageValue(averageSamples); //Get a baseline reading
    load_cell.setScale(calibration_factor);
    
    t.reset();
    sample_ant = 0;
        
    while(1) {
    
    t.start();
    
    S1 = (POF_sensor_1.read())*3.3;// (5.0/65535.0); // 1023 para 10 bits   65536 para 16 bits
    S2 = (POF_sensor_2.read())*3.3;// (5.0/65535.0); // 1023 para 10 bits   65536 para 16 bits
    S3 = (POF_sensor_3.read())*3.3;// (5.0/65535.0);
       
    //load_cell.setScale(calibration_factor);
    float weight = load_cell.getGram();
    
    t.stop();    
    
    sample = t.read();
    
    delta_sample = sample - sample_ant;
    
    //pc.printf("\n loadcell %.2f sensor 1 %f sensor 2 %f sensor 3 %f",weight,S1,S2,S3);
    //pc.printf("\n milsecs %d loadcell %.2f sensor 1 %f sensor 2 %f sensor 3 %f",millis(),weight,S1,S2,S3);
    //pc.printf("\n sample %f  DeltaSample %f loadcell %.2f sensor 1 %f sensor 2 %f sensor 3 %f",sample,delta_sample,weight,S1,S2,S3);
    pc.printf("\n %f  %f %.2f %f %f %f",sample,delta_sample,weight,S1,S2,S3);
      

    sample_ant = sample;
        //wait(0.1);
    }
}



