#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "143.129.39.151"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(&someFunction));
        The function someFunction(void) is called when this interrupt occurs.
    -   Before implementing MQTT, test the multiclick feature first.
        You can simply use 'printf()' to print to a serial terminal. The baud rate is 9600.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

InterruptIn button(USER_BUTTON);
bool flag = false;  //set on interrupt
DigitalOut connected_led(LED3);
char* topic = "clubIOT/feedback"; //publish topic
char* songTopic="clubIOT/songmeta"; //subscribe topic


void buttonpress()
{
    flag = true;
}

void sendMessage(MQTT::Client<MQTTNetwork, Countdown> *client, int qos, char* mqtt_message)
{
    MQTT::Message message;
    char buf[100];
    sprintf(buf, mqtt_message);
    if(qos==0)
        message.qos = MQTT::QOS0;
    else if(qos==1)
        message.qos = MQTT::QOS1;
    else
        message.qos = MQTT::QOS2;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    client->publish(topic, message);
}

void newSong(MQTT::MessageData &data)
{
    MQTT::Message &message = data.message;
    printf("new song: %s \n", (char*)message.payload);
}
    

int main(int argc, char* argv[])
{
    EthernetInterface eth_interface;      //maak ethernet interface
    MQTTNetwork mqttNetwork(&eth_interface);                      //maak mqtt network
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);   //maak een client
    eth_interface.connect();                                    // connect de ethernet interface
    int rc = mqttNetwork.connect(BROKER_NAME, BROKER_PORT);              // connect to the MQTTbroker
    if(rc!=0)
        printf("'tis kapot %d \n", rc);
    client.subscribe(songTopic, MQTT::QOS1, newSong); //subscribe op de songmeta
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "jonas";
    data.username.cstring = "smartcity";
    data.password.cstring = "smartcity";
    client.connect(data);
    
    char* mqtt_message = "";
    
    button.fall(callback(&buttonpress ));
    while(1)
    {
        if(flag)
        {
            button1_onpressed_cb(); //roep debouncer op
            flag = false;           //reset interrupt flag
        }  
        
        if(!button1_busy && isready)
        {
                if (multiclick_state_mem == 1)
                {
                    mqtt_message = "like";
                    sendMessage(&client, 0, mqtt_message);
                }
                else if(multiclick_state_mem == 2)
                {
                    mqtt_message = "dislike";
                    sendMessage(&client, 0, mqtt_message);
                }
                else if(multiclick_state_mem == 4)
                {
                    client.unsubscribe(topic);
                    client.disconnect();
                    eth_interface.disconnect();
                }
                isready = false;
        }
    }
    return 0;
}

