#include "mbed.h"
#include "SDFileSystem.h"
#include <string>
#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <ctype.h>
#include <stddef.h>
#include <cstring>

void textToText(FILE *fid){

    const char s[3] = "?."; //delimiter array
    char line[512]; //char array for storing whole line if match found
    char *token; //for breaking question and answers into separate tokens
    //char input[256];
    char questionAnswer[512]; //for storing question and answer line together
    int j = 0;
    //pc.baud(115200);
    
    std::string str ("What time is it?"); //
    char * input = new char [str.length()+1];
    std::strcpy (input, str.c_str());


    while(1)
    {
        /*
        //get serial data sent from matlab
            if(pc.readable())
            {
                pc.gets(input, sizeof(input));
            }
            else
            {
                pc.printf("Error reading input string\n");
                exit(EXIT_FAILURE);
            }
        */
        
        //convert question to upper case for accurate parsing        
        while(input[j])
        {
            input[j] = toupper(input[j]);
            j++;
        }    
            
        //fid = fopen("robotQA.txt", "r");
        if (fid == NULL)
        {
            printf("Error opening file\n");
            exit(EXIT_FAILURE);
        }
    
        while (!feof(fid))
        {
            while(fgets(line, sizeof(line), fid))
            {
                if (strstr(line, input)) //if line contains what's in <code>question</code>, store it.
                {
                    strncpy(questionAnswer, line, sizeof(questionAnswer));
                }
            }
        }
        fclose(fid);
        
        if(strlen(questionAnswer) == 1)//if questionAnswer is empty after parsing, no answer is found
               printf("I'm not sure. Ask/command something else");
       
        //split string, grab portion after '?' or '.' and send back to matlab to display
        //grab first token
        token = strtok(questionAnswer,s);

        while(token != NULL)
        {
            token = strtok(NULL,s);
            printf("%s\n", token);
            //printf(token);
        }
    }
}

int main() {
    SDFileSystem sd(D11, D12, D13, D10, "sd");
    FILE *fp;
    //char str[100]; //to store the string read from SD card
    
    //Sometimes it takes a few attempts to mount the card succesfully.
    while(sd.mount() != 0){
        printf("Failed to mount SD card.\n");
        wait(0.5);
        continue;
    }
    printf("SD card mounted successfully!\n");
 
    fp = fopen("/sd/qa/robotQA.txt", "r"); //Open file for reading
    //Print error if file could not be opened for reading
    if(fp == NULL) {
        error("Could not open file for read\n");
    }
    //fscanf(fp, "%s", str); //read contents of file into character array
    //printf("%s", str); //print out the contents of the file
    
    textToText(fp);
    sd.unmount();//done, unmount the SD card
}