/* Copyright (c) 2010-2011 mbed.org, MIT License
*  
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"

/*
 * Mokoversity Farm Team
 *
 * ARM mbed IoT workshop at Taipei / Shenzhen.
 * For more information, please see https://www.mokoversity.com/farm
 *
 * Revision:
 *  - 2015.03.17 jollen: initial release
 *  - 2015.04.05 jollen: fix Wifly.cpp - fix SSID network connection problem
 */


/*
 * Sensor Device
 */ 
 
// System status
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Temperature sensor at A0
AnalogIn    temp(P0_23);

/**
 * WiFi Device - Seeed WiFi Shield
 *
 * D1 - TX pin (RX on the WiFi side)
 * D0 - RX pin (TX on the WiFi side)
 * NC - Reset pin; use D5 otherwise the shield might get into reset loop
 * LED1 - TCP status pin
 * "ssid" - hostspot name
 * "password" - hotspot passowrd
 * security method - NONE, WEP_128, WPA
 */
//WiflyInterface eth(D1, D0, D5, LED4, "MICguest", "0266311200", WPA);
WiflyInterface eth(D1, D0, D5, LED4, "WWNet", "mmmmmmmm", WPA);

/*
 * Global Variables
 */ 
int     a;
float   temperature;
int     B = 3975;       //B value of the thermistor                                                    
float   resistance;

int main() 
{
    char data[256];
    int ret;

    wait(3);
    
    // init status
    led1 = 0;
    led2 = 0;
    led3 = 0;
    
    //Use DHCP
    ret = eth.init(); 
    //ret = eth.init("192.168.199.105","255.255.255.0","192.168.199.1");
    if (ret != NULL) {
        led1 = 0;
        led2 = 1;
        led3 = 0;
        led4 = 1;
        
        exit(0);
    }
    
    ret = eth.connect();
    
    while (1) {        
        if (ret == false || ret < 0) {
            led3 = !led3;
            wait(1);
        } else {
            led1 = 1;
            led3 = 0;
            break;
        }
        
        ret = eth.reConnect();
    }
    
    /*
     * We use WoT.City Websocket channel service.
     * See: https://www.mokoversity.com/wotcity
     */
    Websocket ws("ws://wot.city/object/jollentemp2/send");
    while( !ws.connect() );
    led2 = 1;
    
    while(1) {
        // multiply ain by 675 if the Grove shield is set to 5V or 1023 if set to 3.3V
        a = temp * 675;
        
        // get resistance value of the sensor
        resistance = (float)(1023-a)*10000/a;       
        
        //convert resistance value to temperature via datasheet                  
        temperature = 1 / (log(resistance/10000)/B+1/298.15) - 273.15;    

        wait(0.8);
        
        sprintf( data , "{ \"temperature\": %f }",temperature);
        ws.send(data);
    }
}
