#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial lcd(p13,p14);

DigitalOut pn1(p25);
DigitalOut pn2(p26);
DigitalOut box1(p23);
DigitalOut box2(p22);
DigitalOut box3(p21);
DigitalIn  pause(p6);

void clearLCD()
{
    lcd.printf("%c%c",0xFE,0x01);
}
void setLCDpos(int xpos, int ypos)
{
    int pos = 0x80;
    switch (xpos) {
        case 1:
            pos +=0;
            break;
        case 2:
            pos +=64;
            break;
        case 3:
            pos +=20;
            break;
        case 4:
            pos +=84;
            break;
    }
    pos += (ypos-1);
    lcd.printf("%c%c",0xFE,pos);
}
void setBrightness(int lev)
{
    lcd.printf("%c%c",0xFE,lev+127);

    wait(.1);
}
//End LCD Setup


int count = 1;
int cycles = 3500;
int check = 0;



int main()
{
    //clearLCD();
    //setLCDpos(1,1);
    //lcd.printf("Here we go!");
    while(count< cycles) {
        if (pause) {
            check = 1;

            //Trigger Gloveboxes
            box1 = 1;
            box2 = 0;
            box3 = 0;
            wait(.15);
            box1 = 0;
            box2 = 1;
            box3 = 0;
            wait(.15);
            box1 = 0;
            box2 = 0;
            box3 = 1;
            wait(.15);
            box1 = 0;
            box2 = 0;
            box3 = 0;
            wait(1.5);
            //Cylinders Up
            pn1 = 1;
            pn2 = 0;
            wait(1);
            //Cylinders Down
            pn1 = 0;
            pn2 = 1;
            wait(.5);
            //Cylinders Off
            pn1 =0;
            pn2 =0;
            //Wait to repeat
            wait(2);
          
            count++;
            //setLCDpos(2,1);
            //lcd.printf("%d",count);
            pc.printf("%d",count);
        }
        else {
            check = 0;
        }

        //setLCDpos(3,1);
        //lcd.printf("%d", check); 
    } 
}
