#include "mbed.h"
//Serial pc(USBTX, USBRX);
Serial lcd(p28, p27);

// V+/V- outputs cylinder down
DigitalOut out1(p7);
DigitalOut out2(p8);
DigitalOut out3(p9);
DigitalOut out4(p10);
// V+/V- outputs cylinder up
DigitalOut out5(p11);
DigitalOut out6(p12);
DigitalOut out7(p13);
DigitalOut out8(p14);
// Four push buttons left to right
DigitalIn  pushOne(p21);
DigitalIn  pushTwo(p22);
DigitalIn  pushThree(p23);
DigitalIn  pushFour(p24);
// Run switch where p26 will be kept high
// Can probably connect it to the 3.3V out
DigitalIn  runIn(p25);
DigitalOut runOut(p26);

float upTime;
float downTime;
float waitTime;
unsigned int count = 0;
typedef char * string;
string strs[5] = {
    "Up Time",          // 0
    "Down Time",        // 1
    "Wait Time",        // 2
    "Target Count",     // 3
    "Reset Counter"     // 4
};
enum ValveMode {
    UP,
    DOWN
};





void clearLCD()
{
    lcd.printf("%c%c",0xFE,0x01);
}
void setLCDpos(int xpos, int ypos)
{
    int pos = 0x80;
    switch (xpos) {
        case 1:
            pos +=0;
            break;
        case 2:
            pos +=64;
            break;
        case 3:
            pos +=20;
            break;
        case 4:
            pos +=84;
            break;
    }
    pos += (ypos-1);
    lcd.printf("%c%c",0xFE,pos);
}
void setBrightness(int lev)
{
    lcd.printf("%c%c",0x7C,lev+127);
    wait(.1);
}



void setValve(ValveMode dir, int val)
{
    switch(dir) {
        case DOWN:
            out1 = val;
            out2 = val;
            out3 = val;
            out4 = val;
            break;
        case UP:
            out5 = val;
            out6 = val;
            out7 = val;
            out8 = val;
            break;

    }
}


/*void lcdShowParameters(int delay, int cycles)
{
    clearLCD();
    setLCDpos(1,1);
    lcd.printf(strs[strPos]);
    setLCDpos(2,1);
    if (strPos<=2) {
        lcd.printf("%f",times[strPos]);
    } else if(strPos==3) {
        lcd.printf("%d",target);
    } else if(strPos==4) {
        lcd.printf("Y/N?");
    }
}


void lcdConfirmStart()
{
    clearLCD();
    setLCDpos(1,1);
    lcd.printf(strs[strPos]);
    setLCDpos(2,1);
    if (strPos<=2) {
        lcd.printf("%f",times[strPos]);
    } else if(strPos==3) {
        lcd.printf("%d",target);
    } else if(strPos==4) {
        lcd.printf("Y/N?");
    }
}
*/

void printCount (int count)
{
    clearLCD();
    setLCDpos(1,1);
    lcd.printf("CURRENT COUNT IS");
    setLCDpos(2,1);
    lcd.printf("%d",count);
}


int main()
{
    unsigned int route1 = 0;
    //unsigned int route2 = 0;
    float times[3];
    times[0] = 1.0;
    times[1] = 1.0;
    times[2] = 0.2;
    int target = 2000;
    int strPos = 0;
    Timer timer1;

    wait(1);
    clearLCD();
    //setLCDpos(1,1);
    //lcd.printf("Current count is:");
    //setLCDpos(2,1);
    //lcd.printf("%d",0);
    runOut = 1;
    while (1) {
        if (!runIn) {
            if (!route1) {
                clearLCD();
                route1 = 1;
                timer1.start();
            }

            else {
                if(pushOne && timer1.read_ms()>500) {
                    //Go Left
                    if(strPos<1) {
                        strPos=4;
                    } else {
                        strPos--;
                    }

                    clearLCD();
                    setLCDpos(1,1);
                    lcd.printf(strs[strPos]);
                    setLCDpos(2,1);
                    if (strPos<=2) {
                        lcd.printf("%f",times[strPos]);
                    } else if(strPos==3) {
                        lcd.printf("%d",target);
                    } else if(strPos==4) {
                        lcd.printf("Y/N?");
                    }
                    timer1.reset();
                } else if(pushTwo && timer1.read_ms()>100) {
                    //Increment
                    clearLCD();
                    setLCDpos(1,1);
                    lcd.printf(strs[strPos]);
                    setLCDpos(2,1);
                    if(strPos<=2) {
                        times[strPos]=times[strPos]+0.1;
                        lcd.printf("%f",times[strPos]);
                    } else if(strPos==3) {
                        target=target+100;
                        lcd.printf("%d",target);
                    } else if(strPos==4) {
                        setLCDpos(2,1);
                        lcd.printf("YES");
                        count=0;
                    }
                    timer1.reset();
                } else if(pushThree && timer1.read_ms()>100) {
                    //Decrement
                    clearLCD();
                    setLCDpos(1,1);
                    lcd.printf(strs[strPos]);
                    setLCDpos(2,1);
                    if(strPos<=2) {
                        times[strPos]=times[strPos]- 0.1;
                        lcd.printf("%f",times[strPos]);
                    } else if(strPos==3) {
                        target=target-100;
                        lcd.printf("%d",target);
                    } else if(strPos==4) {
                        lcd.printf("NO");
                    }
                    timer1.reset();
                } else if(pushFour && timer1.read_ms()>150) {
                    if(strPos>3) {
                        strPos=0;
                    } else {
                        strPos++;
                    }

                    clearLCD();
                    setLCDpos(1,1);
                    lcd.printf(strs[strPos]);
                    setLCDpos(2,1);
                    if (strPos<=2) {
                        lcd.printf("%f",times[strPos]);
                    } else if(strPos==3) {
                        lcd.printf("%d",target);
                    } else if(strPos==4) {
                        lcd.printf("Y/N?");
                    }
                    timer1.reset();
                }
            }
        } else if (runIn && count<=target) {
            route1=0;
            upTime = times[0];
            downTime = times[1];
            waitTime = times[2];

            setValve(UP, 1);
            wait(upTime);
            setValve(UP, 0);
            wait(waitTime);
            setValve(DOWN, 1);
            wait(downTime);
            setValve(DOWN,0);
            wait(waitTime);
            
            count++;
            printCount(count);
        } else if (count>target) {
            clearLCD();
            setLCDpos(1,1);
            lcd.printf("TARGET REACHED");
            setLCDpos(2,1);
            lcd.printf("%d",target);
            wait(0.1);
        }
    }
}

