#include "mbed.h"
#include "LCD_DISCO_L476VG.h"

#define DISPLAY_LENGTH 6

DigitalOut led(LED1);
LCD_DISCO_L476VG lcd;

InterruptIn center(JOYSTICK_CENTER);
InterruptIn left(JOYSTICK_LEFT);
InterruptIn right(JOYSTICK_RIGHT);
InterruptIn up(JOYSTICK_UP);
InterruptIn down(JOYSTICK_DOWN);

// Events are pointers to functions
// Event loop takes events from queue and executes them
EventQueue queue(64 * EVENTS_EVENT_SIZE);
Thread thread;

uint8_t message[DISPLAY_LENGTH] = {0};
uint8_t msgIndex = 0;
void lcdEventHandler(char c){
    if(c == 'z'){
        memset(message, 0, sizeof(message));
        msgIndex = 0;
    }else{
        message[msgIndex] = c;
        msgIndex = (msgIndex + 1) % DISPLAY_LENGTH;
    }
    lcd.Clear();
    lcd.DisplayString(message);
}

int main(){
    
    // Event loop
    thread.start(callback(&queue, &EventQueue::dispatch_forever));
    
    left.fall(queue.event(lcdEventHandler, 'e'));
    up.fall(queue.event(lcdEventHandler, 'i'));
    right.fall(queue.event(lcdEventHandler, 's'));
    down.fall(queue.event(lcdEventHandler, 'l'));
    center.fall(queue.event(lcdEventHandler, 'z'));
    
    left.mode(PullDown);
    right.mode(PullDown);
    up.mode(PullDown);
    down.mode(PullDown);
    
    while(1) {
    }
}
