#include "mbed.h"
#include "C12832.h"
#include "pitchs.h"
#include "LM75B.h"

LM75B sensor(D14, D15);
PwmOut spkr (D6);
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn center(D4);
C12832 lcd(D11, D13, D12, D7, D10);
enum {CLL,MARIO,JOUE,Sensor} etat = CLL;

int menu_precedent = MARIO;
char message_precedent[]="            ";

void mario(){

int melody[] = {
  NOTE_E7, NOTE_E7, 0, NOTE_E7, 
  0, NOTE_C7, NOTE_E7, 0,
  NOTE_G7, 0, 0,  0,
  NOTE_G6, 0, 0, 0, 

  NOTE_C7, 0, 0, NOTE_G6, 
  0, 0, NOTE_E6, 0, 
  0, NOTE_A6, 0, NOTE_B6, 
  0, NOTE_AS6, NOTE_A6, 0, 

  NOTE_G6, NOTE_E7, NOTE_G7, 
  NOTE_A7, 0, NOTE_F7, NOTE_G7, 
  0, NOTE_E7, 0,NOTE_C7, 
  NOTE_D7, NOTE_B6, 0, 0,

  NOTE_C7, 0, 0, NOTE_G6, 
  0, 0, NOTE_E6, 0, 
  0, NOTE_A6, 0, NOTE_B6, 
  0, NOTE_AS6, NOTE_A6, 0, 

  NOTE_G6, NOTE_E7, NOTE_G7, 
  NOTE_A7, 0, NOTE_F7, NOTE_G7, 
  0, NOTE_E7, 0,NOTE_C7, 
  NOTE_D7, NOTE_B6, 0, 0
};

int noteDurations[] = {
  12, 12, 12, 12, 
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12, 
  12, 12, 12, 12,
  12, 12, 12, 12, 
  12, 12, 12, 12, 
  12, 12, 12, 12, 
  9, 9, 9,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
  9, 9, 9,
  12, 12, 12, 12,
  12, 12, 12, 12,
  12, 12, 12, 12,
};

    for (int thisNote = 0; thisNote < 52; thisNote++) {
        int noteDuration = noteDurations[thisNote];
        spkr.period(1.0/melody[thisNote]);
        spkr=0.25;
        wait(1.0/noteDuration);
        int pauseBetweenNotes = noteDuration * 1.30;
        wait(1.0/pauseBetweenNotes);
        spkr=0;
    }
}

void cll(){
#define DO 262
#define RE 294
#define MI 330

int melody[] = {DO, DO, DO, RE, MI, RE, DO, MI, RE, RE, DO};
int noteDurations[] = {4,4,4,8,8,4,4,4,4,12};
for (int thisNote = 0; thisNote < 52; thisNote++) {
    // to calculate the note duration, take one second
    // divided by the note type.
    //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
    int noteDuration = noteDurations[thisNote];
    //tone(8, melody[thisNote],noteDuration);
    spkr.period(1.0/melody[thisNote]);
    spkr=0.25;
    wait(1.0/noteDuration);
    //wait(1);
    // to distinguish the notes, set a minimum time between them.
    // the note's duration + 30% seems to work well:
    int pauseBetweenNotes = noteDuration * 1.30;
    //wait(pauseBetweenNotes/1000);
    wait(1.0/pauseBetweenNotes);
    // stop the tone playing:
    //noTone(8);
    spkr=0;
}
}

void Afficher_Menu(int Menu)
{
    if (menu_precedent == Menu) return;
    menu_precedent = Menu;
    lcd.cls();
    lcd.locate(0,8);
    //wait(0.050);
    switch(Menu) {
        case CLL :
            lcd.printf("Claire de la lune");
            break;
        case MARIO :
            lcd.printf("Mario");
            break;
        case JOUE :
            lcd.printf("JOUE");
            break;
    }
}

void Afficher_Message(char *Message)
{
    if (strcmp(message_precedent,Message) ==0) return;
    lcd.cls();
    lcd.locate(0,8);
    lcd.printf(Message);

}

void Menu_CLL(int etat)
{
    bool Sortir = false; // On sort du sous-menu
    while (!Sortir) {
        Afficher_Menu(etat);
        switch (etat) {
            case JOUE :
                // évèments
                if (left) {
                    etat = CLL;
                    Sortir=true;
                }
                if (center)cll();
                break;
        }
        wait(0.125);

    }
}


void Menu_Mario(int etat)
{
    bool Sortir = false; // On sort du sous-menu
    while (!Sortir) {
        Afficher_Menu(etat);
        switch (etat) {
            case JOUE :
                // évèments
                if (left) {
                    etat = MARIO;
                    Sortir=true;
                }
                if (center)mario();
                break;
        }
        wait(0.125);

    }
}


int main()
{
    while (1) {
        Afficher_Menu(etat);
        switch (etat) {
            case CLL :
                // évèments
                if (down) etat = MARIO;
                if (right) Menu_CLL(JOUE);
                break;
            case MARIO :
                if (up) etat=CLL;
                if (right) Menu_Mario(JOUE);
                if (down) etat = Sensor;
                break;
            case Sensor :
                lcd.cls();
                lcd.printf("                       ");
                lcd.locate(0,8);
                lcd.printf("Temp = %.3f\n\r", (float)sensor);
                wait(0.5);
                if (up) etat=MARIO;
                break;
                
        }
    wait(0.125);

    }

}
