#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "MSCFileSystem.h"

#define FSNAME "msc"
MSCFileSystem msc(FSNAME);

DigitalOut led1(LED1, "led1");
EthernetNetIf eth;  
HTTPServer svr;

int main() {
  

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
    FSHandler::mount("/msc", "/files"); //Mount /webfs path on /files web path
//  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
    FSHandler::mount("/msc", "/"); //Mount /webfs path on web root path
    FSHandler::mount("/msc", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(80);
  
  printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
  
  return 0;

}









