//--------------------------------------------------------------------------------------------
//Original Property of: charmedlabs.com/pixystart -> arduino_pixy-x.y.z.zip 
//
//Modifications made by: Mathieu Malone
//Modifications: Modified Arduino code to function with mbed development platform
//Output Method: This program uses "Serial pc(USBTX, USBRX)" in order to allow communication
//               between the mbed platform and putty terminal through USB
//
//Latest update by: Mathieu Malone
//Date of last update: July 24th, 2014
//--------------------------------------------------------------------------------------------
//
// begin license header
//
// This file is part of Pixy CMUcam5 or "Pixy" for short
//
// All Pixy source code is provided under the terms of the
// GNU General Public License v2 (http://www.gnu.org/licenses/gpl-2.0.html).
// Those wishing to use Pixy source code, software and/or
// technologies under different licensing terms should contact us at
// cmucam@cs.cmu.edu. Such licensing terms are available for
// all portions of the Pixy codebase presented here.
//
// end license header
//

#ifndef _SPI_H2
#define _SPI_H2
#include "iserial2.h"

#define SPI_RECEIVEBUF_SIZE2     16
#define SPI_TRANSMITBUF_SIZE2    16

#define SS_ASSERT2()             LPC_SGPIO->GPIO_OUTREG2 = 0;
#define SS_NEGATE2()             LPC_SGPIO->GPIO_OUTREG2 = 1<<14;

#define SPI_SYNC_MASK2           0xff00
#define SPI_SYNC_WORD2           0x5a00
#define SPI_SYNC_WORD_DATA2      0x5b00
#define SPI_MIN_SYNC_COUNT2      5

class Spi2 : public Iserial2
{
public:
    Spi2(SerialCallback2 callback2);

    // Iserial methods
    virtual int open2();
    virtual int close2();
    virtual int receive2(uint8_t *buf2, uint32_t len2);
    virtual int receiveLen2();
    virtual int update2();

    void slaveHandler2();

private:
    int checkIdle2();
    int sync2();
    ReceiveQ2<uint16_t> m_rq2;
    TransmitQ2<uint16_t> m_tq2;

    bool m_sync2;
    uint32_t m_recvCounter2;
    uint32_t m_lastRecvCounter2; 
    uint8_t m_syncCounter2;
};

void SPIinit2(SerialCallback2 callback2);

extern Spi2 *g_spi2;

#endif