//--------------------------------------------------------------------------------------------
//Original Property of: charmedlabs.com/pixystart -> arduino_pixy-x.y.z.zip 
//
//Modifications made by: Mathieu Malone
//Modifications: Modified Arduino code to function with mbed development platform
//Output Method: This program uses "Serial pc(USBTX, USBRX)" in order to allow communication
//               between the mbed platform and putty terminal through USB
//
//Latest update by: Mathieu Malone
//Date of last update: July 24th, 2014
//--------------------------------------------------------------------------------------------
//
// begin license header
//
// This file is part of Pixy CMUcam5 or "Pixy" for short
//
// All Pixy source code is provided under the terms of the
// GNU General Public License v2 (http://www.gnu.org/licenses/gpl-2.0.html).
// Those wishing to use Pixy source code, software and/or
// technologies under different licensing terms should contact us at
// cmucam@cs.cmu.edu. Such licensing terms are available for
// all portions of the Pixy codebase presented here.
//
// end license header
//

/*
  Pixy.h - Library for interfacing with Pixy.
  Created by Scott Robinson, October 22, 2013.
  Released into the public domain.

  06.04.2014 v0.1.3 John Leimon 
    + LinkSPI.init() should be called from the setup() 
      function instead of being called automatically from
      the TPixy<LinkSPI> constructor in global scope. This
      is a workaround for a bug (?) in the Arduino DUE in which
      calling SPI.begin() from global scope (via a constructor)
      inhibits the operation of the Serial peripheral in the
      DUE. [As of: Arduino 1.5.6-r2]
*/

#ifndef PIXY_H1
#define PIXY_H1

#include "TPixy1.h"
#include "SPI1.h"


#define PIXY_SYNC_BYTE1              0x5a
#define PIXY_SYNC_BYTE_DATA1         0x5b
#define PIXY_OUTBUF_SIZE1            6

SPI spi1(p5, p6, p7); // mosi, miso, sclk

class LinkSPI1
{
  public:
    void init1()
    {
      outLen1 = 0;
      #ifdef __SAM3X8E__
      // DUE clock divider //
      SPI1.setClockDivider1(84);
      #else
      // Default clock divider //
      //SPI.setClockDivider(SPI_CLOCK_DIV16);
      #endif
    }
    
    uint16_t getWord1()
    {
      // ordering is different because Pixy is sending 16 bits through SPI 
      // instead of 2 bytes in a 16-bit word as with I2C
      uint16_t w1;
      uint8_t c1, count1 = 0;

      if (outLen1)
      {
        w1 = spi1.write(PIXY_SYNC_BYTE_DATA1);
        count1 = outBuf1[outIndex1++];
        if (outIndex1==outLen1)
          outLen1 = 0; 
      }
      else
        w1 = spi1.write(PIXY_SYNC_BYTE1);
      w1 <<= 8;
      c1 = spi1.write(count1);
      w1 |= c1;

      return w1;
    }

    uint8_t getByte1()
    {
      return spi1.write(0x00);
    }
    
    int8_t send(uint8_t *data1, uint8_t len1)
    {
      if (len1>PIXY_OUTBUF_SIZE1 || outLen1!=0)
        return -1;
      memcpy(outBuf1, data1, len1);
      outLen1 = len1;
      outIndex1 = 0;
      return len1;
    }

    void setAddress1(uint8_t addr1)
    {
      addr_1 = addr1;
    }

  private:
    uint8_t outBuf1[PIXY_OUTBUF_SIZE1];
    uint8_t outLen1;
    uint8_t outIndex1;
    uint8_t addr_1;
};


typedef TPixy1<LinkSPI1> Pixy1;

#endif



