// Include
#include "mbed.h"
#include "MD25.h"
#include "mbed.h"
#include "TextLCD.h"
#include "HTU21D.h"
#include "VCNL40x0.h"

void init_motors (void); // prototype initialisation des moteurs
void setSpeed (int speedMotor1, int speedMotor2); // prototye Definir Vitesse moteurs



TextLCD lcd(D2, D3, D4, D5, D6, D7,TextLCD::LCD20x4); // rs, e, d4-d7
MD25 i2c(I2C_SDA, I2C_SCL); //100kHz clock, addr B0, reg 0=speedl, 1=speedr (0 (Full Reverse) 128 (Stop) 255 (Full Forward). 15=mode (set to 0 default)
//HTU21D temp(I2C_SDA, I2C_SCL); // SDA,SC 
//VCNL40x0 VCNL40x0_Device (I2C_SDA, I2C_SCL, VCNL40x0_ADDRESS);      // Define SDA, SCL pin and I2C address 
DigitalIn bouton (USER_BUTTON); // Bouton d'arret total du robot
DigitalIn bouton_poussoir(D9); // Pin PC7 Bouton poussoir demarrage
DigitalIn cap_arret(PA_9); // Pin PA9 capteur d'arret 
 


void init_motors(void){
i2c.setMode(0); // MODE 0, 0=marche arriere 128=stop 255=marche arriere vmax
i2c.setCommand(32); // 0x20 reset encoders
i2c.setCommand(50); // 0X32 Disable time out
//i2c.setCommand(32); // 0x20 reset encoders
//i2c.setCommand(48); // 0X32 Disable speed regulation
 }
 void setSpeed (int vitMotor1, int vitMotor2){
     i2c.setSpeedRegisters(vitMotor1,vitMotor2); 
     }
    

int main() {
    int flag=0;
    unsigned char ID=0;
    //unsigned char Current=0;
    //unsigned int  ProxiValue=0;
   //// unsigned int  AmbiValue=0;
    //float Temp,Hum;
    bouton.mode (PullUp);
    bouton_poussoir.mode (PullUp);
    init_motors();
    



lcd.printf("Majord'home: Hello!\n");
while(bouton_poussoir==1){
    i2c.stopMotors();
    }
setSpeed(60,60);
wait(2);
lcd.cls();
//Temp=temp.sample_ctemp();
//Hum=temp.sample_humid();
//lcd.printf("Temp=%.2f, Humidite=%.2f",Temp,Hum);
//    VCNL40x0_Device.ReadID (&ID);                           // Read VCNL40x0 product ID revision register
//    VCNL40x0_Device.SetCurrent (20);                        // Set current to 200mA
//    VCNL40x0_Device.ReadCurrent (&Current);                 // Read back IR LED current
    

//wait(2);
//lcd.cls();


  while(flag==0) {
    // VCNL40x0_Device.ReadProxiOnDemand (&ProxiValue);    // read prox value on demand
    //VCNL40x0_Device.ReadAmbiOnDemand (&AmbiValue);      // read ambi value on demand
    //lcd.printf("Proxi:%5.0i cts \tAmbi:%5.0i cts \tIlluminance:%7.2f lx", ProxiValue, AmbiValue, AmbiValue/4.0);
    
    //wait(3);
    //lcd.cls();
      cap_arret.read();
      if(cap_arret==0){
          i2c.stopMotors();
          lcd.printf("Engine break ON ");
          lcd.locate(0,0);
          wait(1);
          setSpeed(32,160);
          wait(0.77);//demi tour
          }
          else if(bouton==0){
              i2c.stopMotors();
              lcd.printf("Majord'home: Good Bye! ");
              lcd.locate(0,0);
              flag=1;
              }
              else{
                  setSpeed(64,64);
                  lcd.printf("Engine break OFF");
                  lcd.locate(0,0);           
                  }     
      } 
}


/* Debug Serie
Serial debug(USBTX,USBRX);
debug.format(8,Serial::None,1); 
debug.baud(115200); 
*/







    

  

        
  