/*
 *  This file is derived from the standard MBED SDFileSystem.h file
 *  The class defined here provides only low-level block access to the flash disk, with no filesystem.
 *  
 *  Modifications by John VanLaanen, June 2013
*/

// Header from original file:

/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 
#ifndef MBED_SDFLASHDISK_H
#define MBED_SDFLASHDISK_H
 
#include "mbed.h"
#include <stdint.h>
 
/** Access to an SD Flash Card using SPI
 *
 * @code
 * #include "mbed.h"
 * #include "SDFlashDisk.h"
 *
 * SDFlashDisk sd(p5, p6, p7, p12); // mosi, miso, sclk, cs
 *  
 * }
 */
class SDFlashDisk {
public:
 
    /** Create the object for accessing an SD Card using SPI
     *
     * @param mosi SPI mosi pin connected to SD Card
     * @param miso SPI miso pin conencted to SD Card
     * @param sclk SPI sclk pin connected to SD Card
     * @param cs   DigitalOut pin used as SD Card chip select
     */
    SDFlashDisk(PinName mosi, PinName miso, PinName sclk, PinName cs);
    virtual int disk_initialize();
    virtual int disk_read(uint8_t * buffer, uint64_t block_number);
    virtual int disk_write(const uint8_t * buffer, uint64_t block_number);
    virtual uint64_t disk_sectors();
 
protected:
 
    int _cmd(int cmd, int arg);
    int _cmdx(int cmd, int arg);
    int _cmd8();
    int _cmd58();
    int initialise_card();
    int initialise_card_v1();
    int initialise_card_v2();
    
    int _read(uint8_t * buffer, uint32_t length);
    int _write(const uint8_t *buffer, uint32_t length);
    uint64_t _sd_sectors();
    uint64_t _sectors;
    
    SPI _spi;
    DigitalOut _cs;
    int cdv;
};
 
#endif  // MBED_SDFLASHDISK_H
 