#ifndef __AD7792_H__
#define __AD7792_H__

#include "mbed.h"


/*AD7792 Registers*/
#define AD7792_REG_COMM     0 /* Communications Register(WO, 8-bit) */
#define AD7792_REG_STAT     0 /* Status Register        (RO, 8-bit) */
#define AD7792_REG_MODE     1 /* Mode Register          (RW, 16-bit */
#define AD7792_REG_CONF     2 /* Configuration Register (RW, 16-bit)*/
#define AD7792_REG_DATA     3 /* Data Register          (RO, 16-/24-bit) */
#define AD7792_REG_ID       4 /* ID Register            (RO, 8-bit) */
#define AD7792_REG_IO       5 /* IO Register            (RO, 8-bit) */
#define AD7792_REG_OFFSET   6 /* Offset Register        (RW, 24-bit */
#define AD7792_REG_FULLSALE 7 /* Full-Scale Register    (RW, 24-bit */

/* Communications Register Bit Designations (AD7792_REG_COMM) */
#define AD7792_COMM_WEN     (1 << 7)            /* Write Enable */
#define AD7792_COMM_WRITE   (0 << 6)            /* Write Operation */
#define AD7792_COMM_READ    (1 << 6)            /* Read Operation */
#define AD7792_COMM_ADDR(x) (((x) & 0x7) << 3)  /* Register Address */
#define AD7792_COMM_CREAD   (1 << 2)            /* Continuous Read of Data Register */

/* Status Register Bit Designations (AD7792_REG_STAT) */
#define AD7792_STAT_RDY     (1 << 7) /* Ready. 0 转换完毕       1 正在转换 */
#define AD7792_STAT_ERR     (1 << 6) /* Error (Overrange, Underrange) */
#define AD7792_STAT_CH3     (1 << 2) /* Channel 3 */
#define AD7792_STAT_CH2     (1 << 1) /* Channel 2 */
#define AD7792_STAT_CH1     (1 << 0) /* Channel 1 */

/* Mode Register Bit Designations (AD7792_REG_MODE) */
#define AD7792_MODE_SEL(x)      (((x) & 0x7) << 13) /* Operation Mode Select */
#define AD7792_MODE_CLKSRC(x)   (((x) & 0x3) << 6)  /* ADC Clock Source Select */
#define AD7792_MODE_RATE(x)     ((x) & 0xF)         /* Filter Update Rate Select */

/* AD7792_MODE_SEL(x) options */
#define AD7792_MODE_CONT         0 /* Continuous Conversion Mode */
#define AD7792_MODE_SINGLE       1 /* Single Conversion Mode */
#define AD7792_MODE_IDLE         2 /* Idle Mode */
#define AD7792_MODE_PWRDN        3 /* Power-Down Mode */
#define AD7792_MODE_CAL_INT_ZERO 4 /* Internal Zero-Scale Calibration */
#define AD7792_MODE_CAL_INT_FULL 5 /* Internal Full-Scale Calibration */
#define AD7792_MODE_CAL_SYS_ZERO 6 /* System Zero-Scale Calibration */
#define AD7792_MODE_CAL_SYS_FULL 7 /* System Full-Scale Calibration */

/* AD7792_MODE_CLKSRC(x) options */
#define AD7792_CLK_INT      0 /* Internal 64 kHz Clk not available at the CLK pin */
#define AD7792_CLK_INT_CO   1 /* Internal 64 kHz Clk available at the CLK pin */
#define AD7792_CLK_EXT      2 /* External 64 kHz Clock */
#define AD7792_CLK_EXT_DIV2 3 /* External Clock divided by 2 */

/* AD7792_MODE_RATE(x) options */
//                          fADC (Hz) tSETTLE (ms) Rejection @ 50 Hz/60 Hz (Internal Clock)
#define AD7792_MODE_RATE_470    1       //4
#define AD7792_MODE_RATE_242    2       //8
#define AD7792_MODE_RATE_123    3       //16
#define AD7792_MODE_RATE_62     4       //32
#define AD7792_MODE_RATE_50     5       //40
#define AD7792_MODE_RATE_39     6       //48
#define AD7792_MODE_RATE_33_2   7       //60
#define AD7792_MODE_RATE_19_6   8       //101   90dB (60 Hz only)
#define AD7792_MODE_RATE_16_7   9       //120   80dB (50 Hz only)
#define AD7792_MODE_RATE_16_7_1 10      //120   65dB (50 Hz and 60 Hz)
#define AD7792_MODE_RATE_12_5   11      //160   66dB (50 Hz and 60 Hz)
#define AD7792_MODE_RATE_10     12      //200   69dB (50 Hz and 60 Hz)
#define AD7792_MODE_RATE_8_33   13      //240   70dB (50 Hz and 60 Hz)
#define AD7792_MODE_RATE_6_25   14      //320   72dB (50 Hz and 60 Hz)
#define AD7792_MODE_RATE_4_17   15      //480   74dB


/* Configuration Register Bit Designations (AD7792_REG_CONF) */
#define AD7792_CONF_VBIAS(x)  (((x) & 0x3) << 14)   /* Bias Voltage Generator Enable */
#define AD7792_CONF_BO_EN     (1 << 13)             /* Burnout Current Enable */
#define AD7792_CONF_UNIPOLAR  (1 << 12)             /* Unipolar/Bipolar Enable */
#define AD7792_CONF_BOOST     (1 << 11)             /* Boost Enable */
#define AD7792_CONF_GAIN(x)   (((x) & 0x7) << 8)    /* Gain Select */
#define AD7792_CONF_REFSEL(x) (((x) & 0x1) << 7)    /* INT/EXT Reference Select */
#define AD7792_CONF_BUF       (1 << 4)              /* Buffered Mode Enable */
#define AD7792_CONF_CHAN(x)   ((x) & 0x7)           /* Channel select */

/* AD7792_CONF_GAIN(x) options */
#define AD7792_GAIN_1       0
#define AD7792_GAIN_2       1
#define AD7792_GAIN_4       2
#define AD7792_GAIN_8       3
#define AD7792_GAIN_16      4
#define AD7792_GAIN_32      5
#define AD7792_GAIN_64      6
#define AD7792_GAIN_128     7

/* AD7792_CONF_REFSEL(x) options */
#define AD7792_REFSEL_INT   1   /* Internal Reference Selected. */
#define AD7792_REFSEL_EXT   0   /* External Reference Applied between REFIN(+) and REFIN(�). */

/* AD7792_CONF_CHAN(x) options */
#define AD7792_CH_AIN1P_AIN1M   0 /* AIN1(+) - AIN1(-) */
#define AD7792_CH_AIN2P_AIN2M   1 /* AIN2(+) - AIN2(-) */
#define AD7792_CH_AIN3P_AIN3M   2 /* AIN3(+) - AIN3(-) */
#define AD7792_CH_AIN1M_AIN1M   3 /* AIN1(-) - AIN1(-) */
#define AD7792_CH_TEMP          6 /* Temp Sensor */
#define AD7792_CH_AVDD_MONITOR  7 /* AVDD Monitor */

/*AD7792_CONF_Bias(x) options*/
#define AD7792_BIAS_DISABLED   0 /*Bias voltage generator disabled*/
#define AD7792_BIAS_AIN1       1 /*Bias voltage connected to AIN1(.)*/
#define AD7792_BIAS_AIN2       2 /*Bias voltage connected to AIN2(.)*/
#define AD7792_BIAS_RESVERED   3 /*Reserved*/

/* ID Register Bit Designations (AD7792_REG_ID) */
#define AD7792_ID           0xA
#define AD7792_ID_MASK      0xF

/* IO (Excitation Current Sources) Register Bit Designations (AD7792_REG_IO) */
#define AD7792_IEXCDIR(x)   (((x) & 0x3) << 2)
#define AD7792_IEXCEN(x)    (((x) & 0x3) << 0)

/* AD7792_IEXCDIR(x) options*/
#define AD7792_DIR_IEXC1_IOUT1_IEXC2_IOUT2  0  /* IEXC1 connect to IOUT1, IEXC2 connect to IOUT2 */
#define AD7792_DIR_IEXC1_IOUT2_IEXC2_IOUT1  1  /* IEXC1 connect to IOUT2, IEXC2 connect to IOUT1 */
#define AD7792_DIR_IEXC1_IEXC2_IOUT1        2  /* Both current sources IEXC1,2 connect to IOUT1  */
#define AD7792_DIR_IEXC1_IEXC2_IOUT2        3  /* Both current sources IEXC1,2 connect to IOUT2 */

/* AD7792_IEXCEN(x) options*/
#define AD7792_EN_IXCEN_10uA                1  /* Excitation Current 10uA */
#define AD7792_EN_IXCEN_210uA               2  /* Excitation Current 210uA */
#define AD7792_EN_IXCEN_1mA                 3  /* Excitation Current 1mA */

#ifndef u8
typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;
typedef uint64_t    u64;
typedef volatile u8     vu8;
typedef volatile u32    vu32;
typedef volatile u64    vu64;
#endif

/* Initialize AD7792 and check if the device is present*/
bool AD7792_Init(void);

/* Sends 32 consecutive 1's on SPI in order to reset the part. */
void AD7792_Reset(void);

u16 AD7792_SetUpdateRate(u8 rate);
void AD7792_checkAllRegs();
u16 AD7792_SPIreadTwoRegisters(u8 regAddress);
u16 AD7792_SetBias(u8 bias);

///* Reads the value of the selected register. */
//unsigned long AD7792_GetRegisterValue(unsigned char regAddress,
//                                    unsigned char size,
//                                      unsigned char modifyCS);
//
///* Writes a value to the register. */
//void AD7792_SetRegisterValue(unsigned char regAddress,
//                           unsigned long regValue,
//                           unsigned char size,
//                             unsigned char modifyCS);


u16 AD7792_SetBuf(u8 buf);


/* Sets the operating mode of AD7792. */
u16 AD7792_SetMode(unsigned long mode);

/* Selects the channel of AD7792. */
u16 AD7792_SetChannel(unsigned long channel);

/* Sets the gain of the In-Amp. */
u16 AD7792_SetGain(unsigned long gain);

/* Sets the reference source for the ADC. */
u16 AD7792_SetIntReference(unsigned char type);

/* Performs the given calibration to the specified channel. */
u16 AD7792_Calibrate(unsigned char mode, unsigned char channel);

unsigned short AD7792_SingleConversion(void);
unsigned short AD7792_ContinusConversion(void);

/* Returns the average of several conversion results. */
unsigned long AD7792_ContinuousReadAvg(unsigned char sampleNumber);


void AD7792_SPI_configure(void);
bool AD7792_WaitRdy(void);
unsigned char AD7792_Status(void);

float AD7792_AVdd_Monitor(void);

bool ADXL362_selftest(float *pExp, float *pStd);
bool ADXL103_selftest(float *pExp, float *pStd);
bool LOAD_selftest(float *pExp, float *pStd);
void AD7792_test(void);

u16 AD7792_POWER_DOWN(void);
#endif  // _AD7792_H_
