#include "mbed.h"
#include "QEI.h"
#include "MODSERIAL.h"

#define MCONV 10900

AnalogOut tri(p18);
DigitalIn Enable(p10);
MODSERIAL pc(USBTX,USBRX);
QEI wheel (p24, p25,NC, 1800);
AnalogIn load(p20);
unsigned short value = 0x0500;
float Set=25;
LocalFileSystem local("local");
Timer SystemTime;
Timer LogTime;
Timer LoopTime;
Timer SampleTime;
BusOut leds(LED1, LED2, LED3, LED4);
float errorup=1;
float errorlow=-1;

int main()
{
    pc.printf("alive");
    Enable.mode(PullDown);
    int filenumber=0;
    bool FLAG =0;
    char filename[22];
    leds=0x1;
    pc.printf("alsoHere");
    Set=30;
    value=0x0500;
    while(1) {
        while(!FLAG) {
            sprintf(filename,"/local/data%04d.txt",filenumber++);
            FILE *SetupFile= fopen(filename, "r");
            if (SetupFile != NULL) fclose(SetupFile);
            else FLAG=1;
        }
        leds=0x2;
        tri.write_u16(value);
        while(pc.getcNb()!='s');

        FILE *fp =fopen(filename, "w");  // Open "out.txt" on the local file system for writing
        fprintf(fp,"Time(s), EncoderCnts, LoadCell, Meters, Newtons \n");

        tri = 0;
        //wait(20);
        SystemTime.start();
        LogTime.start();
        LoopTime.start();
        SampleTime.start();
        leds=0xF;
        float avgtotal=0;
        float avgcnt=0;
        wheel.reset();
        char check = '0';
        while(check!= 'S') {
check = pc.getcNb();
                if(check=='y') {
                    //while(pc.getcNb()=='y');
                    Set+=3;
                    pc.printf("\r\nTarget = %flbs",Set);
                }
                if(check=='h') {
                    //while(pc.getcNb()=='h');
                    Set-=3;
                    pc.printf("\r\nTarget = %flbs",Set);
                }

            //wait_ms(100);
            if (LogTime.read_ms()>100) {
                int temp2 = wheel.getPulses();
                float temp = ((avgtotal/avgcnt)+1.7026)/336.85;
                fprintf(fp,"%f ,%i ,%f , %f, %f\n", SystemTime.read(),temp2,temp,(float)temp2/10900.000,avgtotal/avgcnt*4.45);
                LogTime.reset();
                
            }
            avgtotal+=336.85*load.read()-1.7026;
            avgcnt+=1.0;
            if (LoopTime.read_ms()>5) {

                LoopTime.reset();

                float Actual=avgtotal/avgcnt;
                avgtotal=0;
                avgcnt=0;
                float Error = (Set-Actual);
                if (Error>errorup)Error=errorup;
                if (Error<errorlow)Error=errorlow;
                value=value+Error;
                // pc.printf("%x\r\n",value);

                if(value > 0xFFFE) {
                    value=0xFFFE;
                }
                if(value < 0x00A0) {
                    value=0x00A0;
                }
                tri.write_u16(value);


            }// 4.45 lbs to N
            
              // if (wheel.getPulses()>MCONV)Set=200;
            if (wheel.getPulses()>1.6*MCONV)Set=220;
            if (wheel.getPulses()>2.2*MCONV)Set=240;
            if (wheel.getPulses()>2.8*MCONV)Set=260;
            if (wheel.getPulses()>3.4*MCONV)Set=280;
            if (wheel.getPulses()>4*MCONV)Set=300;
            if (wheel.getPulses()>4.6*MCONV)Set=320;
            /*if (wheel.getPulses()>5.8*MCONV)Set=210;
            if (wheel.getPulses()>6.6*MCONV)Set=220;
            if (wheel.getPulses()>7*MCONV)Set=240;*/
            
            
/*
if (wheel.getPulses()>MCONV)Set=40;
            if (wheel.getPulses()>1.8*MCONV)Set=60;
            if (wheel.getPulses()>2.6*MCONV)Set=80;
            if (wheel.getPulses()>3.4*MCONV)Set=100;
            if (wheel.getPulses()>4.2*MCONV)Set=120;
            if (wheel.getPulses()>5*MCONV)Set=140;
            if (wheel.getPulses()>5.8*MCONV)Set=160;
            if (wheel.getPulses()>6.6*MCONV)Set=180;
            if (wheel.getPulses()>7*MCONV)Set=200;
            */
        }
        fclose(fp);
        tri.write_u16(0x0400);
        leds=0x8;
        Set=30;
        while(pc.getcNb()!='R') {
            avgtotal+=336.85*load.read()-1.7026;
            avgcnt+=1.0;
            if (LoopTime.read_ms()>5) {

                LoopTime.reset();

                float Actual=avgtotal/avgcnt;
                avgtotal=0;
                avgcnt=0;
                float Error = (Set-Actual);
                if (Error>errorup)Error=errorup;
                if (Error<errorlow)Error=errorlow;
                value=value+Error;
                // pc.printf("%x\r\n",value);

                if(value > 0xFFFE) {
                    value=0xFFFE;
                }
                if(value < 0x00A0) {
                    value=0x00A0;
                }
                tri.write_u16(value);
            }
        }
    }
}