#include "mbed.h"
#include "Motor.h"
#include "rtos.h"


int count = 0;
int status = 0;

Serial blue(p28,p27);
Motor m1(p25, p7, p8); // pwm, fwd, rev
Motor m2(p26, p5, p6); // pwm, fwd, rev



// IR reciever connected to pin 14
RawSerial device(p13, p14);


//speaker 
PwmOut  speaker (p21);

// LED inctating and testing functionality 
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);


// RC control using Bluetooth and BlueFruit App
void bluetooth_thread(void const *args)
{
    while(1) {
        char bnum=0;
        char bhit=0;
    if(status == 0)
    {   if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                // for case 1 - 4 (button 1 - 4) could be added additional functionality
                    switch (bnum) {
                        case '5': //button 5 (FORWARD)
                            if (bhit=='1') {
                                m1.speed(0.5);
                                m2.speed(0.55);
                            } else {
                                m1.speed(0.0);
                                m2.speed(0.0);  
                            }                    
                            break;
                        case '6': //button 6 (REVERSE)
                            if (bhit=='1') {
                                m1.speed(-0.5);
                                m2.speed(-0.54); 
                            } else {
                                m1.speed(0.0);
                                m2.speed(0.0);
                            }
                            break;
                        case '7': //button 7 (LEFT)
                            if (bhit=='1') {
                                m1.speed(-0.5);
                                m2.speed(0.5);
                            } else {
                                m1.speed(0.0);
                                m2.speed(0.0);
                            }
                            break;
                        case '8': //button 8 (RIGHT)
                            if (bhit=='1') {
                                m1.speed(0.5);
                                m2.speed(-0.54);
                            } else {
                                m1.speed(0.0);
                                m2.speed(0.0);
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
    
    // LED 4 blinking to indicate that robot is shot and could not move
    else if (status == 1)
    {
        myled4 = !myled4;
        m1.speed(0.0);
        m2.speed(0.0);
        
    }
        
    Thread::wait(200);
        
    }
}

// play sound and blinking 
void blink_sound(void const *args) {
    
    while (1){
 
    if (status == 1)
    {
        myled1 = !myled1;    
        speaker =0.9; //90% duty cycle - max volume
        Thread::wait(700);
        speaker=0.0; // turn off audio
    }

    
    Thread::wait(500);
    }
    
}


int main()
{
    
    Thread thread1(bluetooth_thread);
    Thread thread2(blink_sound);
    device.baud(2400);
    speaker.period(1.0/350.0); // 350hz period
    
    while(1) {
        
       
            if(device.readable())
            {
                device.getc();
                myled2 = 1;
                status = 1;
                wait(1);
                myled2 = 0;
                device.putc(0);
            }
            
            // after few cycles the robot rebooting
            if(device.readable() == 0)
            {
                status = 0;
            }
        
        Thread::wait(100);
    }

}

