#include "mbed.h"
#include "mcp3208.h"

MCP3208 input1(PA_7, PA_6, PA_5, PA_4); //MCP3208(PinName mosi, PinName miso, PinName clk, PinName cs)
MCP3208 input2(PA_7, PA_6, PA_5, PA_4); //MCP3208(PinName mosi, PinName miso, PinName clk, PinName cs)
MCP3208 input3(PA_7, PA_6, PA_5, PA_4); //MCP3208(PinName mosi, PinName miso, PinName clk, PinName cs)
MCP3208 input4(PA_7, PA_6, PA_5, PA_4); //MCP3208(PinName mosi, PinName miso, PinName clk, PinName cs)

//MCP3208 input1(PB_5, PB_4, PB_3, PA_11);
//MCP3208 input1(p5, p6, p7, p8);

//Serial pc(dp16,dp15);
// Serial pc(p9,p10);
//Serial pc(USBTX, USBRX);
Serial pc(PA_3, PA_1);

Ticker datalog;
Timer t;

char datastr0[5];
char datastr1[5];
char datastr2[5];
char datastr3[5];
char datastr4[5];
char datastr5[5];

char datastr6[5];

int data0, data10, data20, data30;
int data1, data11, data21, data31;
int data2, data12, data22, data32;
int data3, data13, data23, data33;
int data4, data14, data24, data34;
int data5, data15, data25, data35;

// Credit: Erik Olieman
// http://developer.mbed.org/questions/5149/Serial-port-on-LPC1114-is-slow/
void intToString(char *buffer, int value)
{
    int temp;
    temp = value / 1000;
    buffer[0] = temp + '0';
    value = value - temp * 1000;

    temp = value / 100;
    buffer[1] = temp + '0';
    value = value - temp * 100;

    temp = value / 10;
    buffer[2] = temp + '0';
    value = value - temp * 10;

    temp = value / 1;
    buffer[3] = temp + '0';
    value = value - temp * 1;

    buffer[4] = '\0';
}

bool tickerActivated = false;

void log_data()
{
    tickerActivated = true;
}

int main()
{
    int tt = 0;
    t.start();

    pc.baud(921600);
    //pc.baud(9600);
    pc.printf("Working!!\n\r");

    datalog.attach_us(&log_data,1000); // 1000us = 1ms

    while(1) {
        
        data0 = input1.binary(0);
        data1 = input1.binary(1);
        data2 = input1.binary(2);
        data3 = input1.binary(3);
        data4 = input1.binary(4);
        data5 = input1.binary(5);
        
        data10 = input2.binary(0);
        data11 = input2.binary(1);
        data12 = input2.binary(2);
        data13 = input2.binary(3);
        data14 = input2.binary(4);
        data15 = input2.binary(5);
        
        data20 = input3.binary(0);
        data21 = input3.binary(1);
        data22 = input3.binary(2);
        data23 = input3.binary(3);
        data24 = input3.binary(4);
        data25 = input3.binary(5);
        
        
        data30 = input4.binary(0);
        data31 = input4.binary(1);
        data32 = input4.binary(2);
        data33 = input4.binary(3);
        data34 = input4.binary(4);
        data35 = input4.binary(5);


        // Timing methods to verify 1 ms loop time / 1 kHz update speed
        // tt = t.read_ms();
        tt++;
        if(tt>=10000) {
            tt = 0;
        }
        intToString(datastr6,tt);

        if(tickerActivated == true) {
            tickerActivated = false;
            pc.printf("%04d,%04d,%04d,%04d,%04d,%04d\n\r",data0,data1,data2,data3,data4,data5);
            pc.printf("%04d,%04d,%04d,%04d,%04d,%04d\n\r",data10,data11,data12,data13,data14,data15);
            pc.printf("%04d,%04d,%04d,%04d,%04d,%04d\n\r",data20,data21,data22,data23,data24,data25);
            pc.printf("%04d,%04d,%04d,%04d,%04d,%04d\n\r",data30,data31,data32,data33,data34,data35);
            
        }

    }
}


