// Modified the Hello World example to use the keyboard to
// change the LED blink rate.
//
// Open a terminal window on your computer and use the keys
//     u = up
//     d = down
//     q = stop blinking
//     s = start blinking

#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

int main() {

    float delay = 0.2;
    char c;
    bool blink = 1; // One blink LED, zero to stop blinking

    while(1) {
    
        if (blink == 1) {
            myled = 1;
            wait(delay);
            myled = 0;        
            wait(delay);
        }
                    
        if(pc.readable()) {
            c = pc.getc();
     
            if (blink == 1) {
     
                if (c == 'u') 
                {
                   delay = delay + 0.2;
                   pc.printf("Up %3.2f ms\r\n", delay);
                }
                
                if (c == 'd') {
                    delay = delay - 0.2;
                    if (delay < 0.2) {delay = 0.2;}
                    pc.printf("Down %3.2f ms\r\n", delay);
                }
                 if (c == 'q') {
                    blink = 0;
                    pc.printf("----- Blinking stopped -----\r\n");
                }                             
            }
            else {  //  Restart blinking
       
                if (c == 's') {
                    pc.printf("----- Started LED blink -----\r\n");
                    blink = 1;
                }
            }                      
        }           
    }
}
