#include "mbed.h"   
#include "XBeeDevice.hpp"
#include "XBeeApiCmdAt.hpp"           
 
/* Use the blocking API ... */
#define USE_BLOCKING
 
Serial pc(USBTX, USBRX); // tx, rx
 
XBeeDevice xbeeDevice( PTA2, PTA1, NC, NC );
   
int main() {
#if defined USE_BLOCKING
    XBeeApiCmdAtBlocking atIf;
#else
    XBeeApiCmdAt atIf;
#endif
    XBeeDevice::XBeeDeviceReturn_t status;
    
    if( ! ( xbeeDevice.registerDecoder( &atIf ) ))
    {
        /* TODO: Oh dear */
    }
    
    /* Get API mode 2 set up */
    status = xbeeDevice.setUpApi();

    if( status != XBeeDevice::XBEEDEVICE_OK )
    {
        pc.printf("\r\n[%4d]: XBeeStatus: %d\r\n",__LINE__,status);
    }
#if !defined USE_BLOCKING
    else
    {
        /* If we got the API set up should be OK to send an API command
           Request the Firmware and Hardware versions from the XBee */
        atIf.requestFirmwareVersion();
        atIf.requestHardwareVersion();
        atIf.requestChannel();
    }
#endif

    while( 1 ) {
        uint16_t hwVer, fwVer;
        uint8_t channel;

        wait(1);
        
        /* If we've now retrieved the HW and FW versions, proudly tell the
           serial port */
        
        if( atIf.getHardwareVersion( &hwVer ) )
        {
            printf("HW VER: 0x%04x\r\n", hwVer);
        }
        if( atIf.getFirmwareVersion( &fwVer ) )
        {
            printf("FW VER: 0x%04x\r\n", fwVer);
        }
        if( atIf.getChannel( &channel ) )
        {
            printf("Channel: 0x%02x\r\n", channel);
            if( channel != 0x0d ) 
            {
                atIf.setChannel( 0x0d );
            }
        }
        
        /* Any spare (i.e. unprocessed) bytes in the rx buffer to be 
           worried about? */
        xbeeDevice.dumpRxBuffer( &pc, true );
    }
    
#if 0
    pc.printf("\r\n[%4d]: Done\r\n",__LINE__);
#endif
}