/**
   @file
   @brief Set up TestSupportLite for simple tests

   @author John Bailey 

   @copyright Copyright 2014 John Bailey

   @section LICENSE
   
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

#if !defined TESTSUPPORTSIMPLE_HPP
#define      TESTSUPPORTSIMPLE_HPP

#if defined __CC_ARM
#include "mbed.h"
extern Serial pc;   
#define TS_PRINTF( ... ) pc.printf(__VA_ARGS__)
#else
#include <stdio.h>
#define TS_PRINTF( ... ) printf(__VA_ARGS__)
#endif

#include "TestSupportLite.hpp"

extern TestResults tst_glob;

/** Text to be displayed for each test being run */
#define TEST_TXT "[%03d] {%c} %s\r\n"

/** Text to be displayed at the end of the test run */
#define DONE_TXT "----- [%d tests run, %d passed]\r\n"

/** Text to be displayed for failing tests */
#define FAIL_TXT "      Test at %s:%d\r\n"

#define TEST_OUT( _p, _t ) do { tst_glob.registerResult( _p ); TS_PRINTF( TEST_TXT, tst_glob.getCount(), _p?'X':' ', _t ); } while (0)
#define DONE_OUT() do { TS_PRINTF( DONE_TXT, tst_glob.getCount(), tst_glob.getPassed() ); } while ( 0 )
#define FAIL_OUT() do { TS_PRINTF( FAIL_TXT, __FILE__, __LINE__ ); } while ( 0 )

#endif